/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.zoom;

import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.sketch.zoom.ZoomOriginStorage;
import com.harrand.sketch.zoom.presets.ZoomPresetsCtrl;
import com.harrand.util.FileHelper;
import com.harrand.util.LogUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public final class Zoomer {
    public static double[] getZoomIncrements() {
        return ZoomPresetsCtrl.getInstance().getRatios();
    }

    public static Zoom getNextZoom(Zoom currentZoom, int direction) {
        Zoom newZoom = direction == 1 ? Zoomer.getNextZoomIn(currentZoom) : Zoomer.getNextZoomOut(currentZoom);
        return newZoom;
    }

    private static Zoom getNextZoomIn(Zoom currentZoom) {
        double[] zoomIncrements = Zoomer.getZoomIncrements();
        int length = zoomIncrements.length;
        double currentLevel = currentZoom.getLevel();
        double newLevel = Zoomer.getMaxZoomLevel();
        for (int i = 0; i < length; ++i) {
            if (!(currentLevel < zoomIncrements[i])) continue;
            newLevel = zoomIncrements[i];
            break;
        }
        return new Zoom(newLevel);
    }

    private static Zoom getNextZoomOut(Zoom currentZoom) {
        double[] zoomIncrements = Zoomer.getZoomIncrements();
        int length = zoomIncrements.length;
        double currentLevel = currentZoom.getLevel();
        double newLevel = Zoomer.getMinZoomLevel();
        for (int i = length - 1; i >= 0; --i) {
            if (!(currentLevel > zoomIncrements[i])) continue;
            newLevel = zoomIncrements[i];
            break;
        }
        return new Zoom(newLevel);
    }

    public static double getMaxZoomLevel() {
        double[] zoomIncrements = Zoomer.getZoomIncrements();
        return zoomIncrements[zoomIncrements.length - 1];
    }

    public static double getMinZoomLevel() {
        return Zoomer.getZoomIncrements()[0];
    }

    public static Shape zoomDisp(Shape shape, Zoom zoom) {
        if (!zoom.isZoomed()) {
            return shape;
        }
        double zoomLevel = zoom.getLevel();
        if (shape instanceof Line2D) {
            return Zoomer.zoom((Line2D)shape, zoomLevel);
        }
        if (shape instanceof Arc2D) {
            return Zoomer.zoom((Arc2D)shape, zoomLevel);
        }
        if (shape instanceof Ellipse2D) {
            return Zoomer.zoom((Ellipse2D)shape, zoomLevel);
        }
        if (shape instanceof Rectangle2D) {
            return Zoomer.zoom((Rectangle2D)shape, zoomLevel);
        }
        if (shape instanceof RoundRectangle2D) {
            return Zoomer.zoom((RoundRectangle2D)shape, zoomLevel);
        }
        if (shape instanceof Rectangle) {
            return Zoomer.zoom((Rectangle)shape, zoomLevel);
        }
        if (shape instanceof Polygon) {
            return Zoomer.zoom((Polygon)shape, zoomLevel);
        }
        LogUtil.logErr("Zoomer.zoomdisp: shape not matched: " + shape);
        return shape;
    }

    public static Shape zoom(Line2D line, double factor) {
        double newX1 = line.getX1() * factor;
        double newY1 = line.getY1() * factor;
        double newX2 = line.getX2() * factor;
        double newY2 = line.getY2() * factor;
        return new Line2D.Double(newX1, newY1, newX2, newY2);
    }

    public static Shape zoom(Arc2D arc, double factor) {
        double newX = arc.getX() * factor;
        double newY = arc.getY() * factor;
        double newWidth = arc.getWidth() * factor;
        double newHeight = arc.getHeight() * factor;
        return new Arc2D.Double(newX, newY, newWidth, newHeight, arc.getAngleStart(), arc.getAngleExtent(), arc.getArcType());
    }

    public static Shape zoom(Ellipse2D ellipse, double factor) {
        double newX = ellipse.getX() * factor;
        double newY = ellipse.getY() * factor;
        double newWidth = ellipse.getWidth() * factor;
        double newHeight = ellipse.getHeight() * factor;
        return new Ellipse2D.Double(newX, newY, newWidth, newHeight);
    }

    public static Rectangle2D zoom(Rectangle2D rect, double factor) {
        double newX = rect.getX() * factor;
        double newY = rect.getY() * factor;
        double newW = rect.getWidth() * factor;
        double newH = rect.getHeight() * factor;
        return new Rectangle2D.Double(newX, newY, newW, newH);
    }

    public static RoundRectangle2D zoom(RoundRectangle2D rect, double factor) {
        double newX = rect.getX() * factor;
        double newY = rect.getY() * factor;
        double newW = rect.getWidth() * factor;
        double newH = rect.getHeight() * factor;
        double newRW = rect.getArcWidth() * factor;
        double newRH = rect.getArcHeight() * factor;
        RoundRectangle2D.Double zmRect = new RoundRectangle2D.Double(newX, newY, newW, newH, newRW, newRH);
        return zmRect;
    }

    public static Rectangle zoom(Rectangle rect, double factor) {
        int newX = (int)((double)rect.x * factor);
        int newY = (int)((double)rect.y * factor);
        int newW = (int)((double)rect.width * factor);
        int newH = (int)((double)rect.height * factor);
        return new Rectangle(newX, newY, newW, newH);
    }

    public static Shape zoom(Polygon polygon, double factor) {
        int count = polygon.npoints;
        int[] newXs = new int[count];
        int[] newYs = new int[count];
        for (int i = 0; i < count; ++i) {
            newXs[i] = (int)((double)polygon.xpoints[i] * factor);
            newYs[i] = (int)((double)polygon.ypoints[i] * factor);
        }
        Polygon newPolygon = new Polygon(newXs, newYs, newXs.length);
        return newPolygon;
    }

    public static Rectangle2D zoomCentered(Rectangle2D rect, double zoomRatio) {
        return Zoomer.zoomCentered(rect, zoomRatio, null, null);
    }

    public static Rectangle2D zoomCentered(Rectangle2D rect, double zoomRatio, ZoomOriginStorage zoomOriginStorage, Zoom newZoom) {
        double scale = 1.0 / zoomRatio;
        double width = rect.getWidth() * scale;
        double height = rect.getHeight() * scale;
        double deltaWidth = width - rect.getWidth();
        double deltaHeight = height - rect.getHeight();
        double x = rect.getX() - 0.5 * deltaWidth;
        double y = rect.getY() - 0.5 * deltaHeight;
        Rectangle2D.Double newRect = new Rectangle2D.Double(x, y, width, height);
        return newRect;
    }

    public static Point2D zoom(Point2D p, double factor) {
        return new Point2D.Double(p.getX() * factor, p.getY() * factor);
    }

    public static Point zoom(Point p, double factor) {
        return new Point((int)(p.getX() * factor), (int)(p.getY() * factor));
    }

    public static Dimension zoom(Dimension d, double factor) {
        return new Dimension((int)(d.getWidth() * factor), (int)(d.getHeight() * factor));
    }

    public static Point unZoom(Point p, double factor) {
        return Zoomer.zoom(p, 1.0 / factor);
    }

    public static Rectangle unZoom(Rectangle rect, Zoom zoom) {
        double zmLevel = 1.0 / zoom.getLevel();
        return Zoomer.zoom(rect, zmLevel);
    }

    public static int getMaxPercentLevel() {
        return (int)(Zoomer.getMaxZoomLevel() * 100.0);
    }

    public static int getMinPercentLevel() {
        return (int)(Zoomer.getMinZoomLevel() * 100.0);
    }

    public static boolean isWithinRange(double newLevel) {
        return Zoomer.getMinZoomLevel() <= newLevel && newLevel <= Zoomer.getMaxZoomLevel();
    }

    public static String getOutOfRangeMsg(int levelPercent) {
        return levelPercent + "% " + FileHelper.getRes("err.zoom.out.range.phrase") + " " + Zoomer.getMinPercentLevel() + "% " + FileHelper.getRes("and") + " " + Zoomer.getMaxPercentLevel() + "%.";
    }
}

