/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.text.scanner;

import com.harrand.coreclasses.element.Range;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.text.scanner.ISingleWordScanner;
import java.util.ArrayList;
import java.util.List;

public final class NumericScanner
implements ISingleWordScanner {
    private static NumericScanner ref__ = new NumericScanner();

    private NumericScanner() {
    }

    public static NumericScanner instance() {
        return ref__;
    }

    @Override
    public boolean evaluate(String word) {
        return StrHelper.isNumeric(word);
    }

    @Override
    public List getRanges(String text, int offset) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        String cleanText = StrHelper.removePunctuation(text);
        String[] tokens = cleanText.split(" ");
        int index = 0;
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (this.evaluate(token)) {
                ranges.add(new Range(index + offset, new Integer(token.length())));
            }
            index += token.length() + 1;
        }
        return ranges;
    }

    @Override
    public String getStyleName() {
        return "Number";
    }
}

