/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.text.scanner;

import com.harrand.coreclasses.element.Range;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.text.scanner.IMultiwordScanner;
import java.util.ArrayList;
import java.util.List;

public final class EncloseScanner
implements IMultiwordScanner {
    private String styleName_;
    private String encloser_;
    private int encloserLength_;
    private static final int ENCLOSER_NEXT = 0;
    private static final int EOL_NEXT = 1;
    private static final int END_NEXT = 2;

    public EncloseScanner(String styleName, String encloser) {
        this.encloser_ = encloser;
        this.styleName_ = styleName;
        this.encloserLength_ = this.encloser_.length();
    }

    @Override
    public Range getEffectedRange(String text, Range range) {
        return StrHelper.getEolRange(text, range);
    }

    @Override
    public List getRanges(String text, int offset) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        int defaultEnd = text.length() + offset;
        int start = 0;
        int end = 0;
        int index = 0;
        while (index > -1) {
            if ((index = text.indexOf(this.encloser_, index)) <= -1) continue;
            start = index + offset;
            int nextTokenType = this.getNextTokenType(text, ++index);
            switch (nextTokenType) {
                case 0: {
                    index = text.indexOf(this.encloser_, index);
                    end = index + offset + this.encloserLength_;
                    ++index;
                    break;
                }
                case 1: {
                    index = text.indexOf("\n", index);
                    end = index + offset;
                    break;
                }
                case 2: {
                    index = -1;
                    end = defaultEnd;
                }
            }
            ranges.add(new Range(start, end));
        }
        return ranges;
    }

    @Override
    public String getStyleName() {
        return this.styleName_;
    }

    @Override
    public boolean needsUpdate(String examineText) {
        return examineText.indexOf(this.encloser_) >= 0;
    }

    private int getNextTokenType(String text, int pos) {
        int endIndex = text.length();
        int encloserIndex = text.indexOf(this.encloser_, pos);
        int eolIndex = text.indexOf("\n", pos);
        if (encloserIndex == -1) {
            encloserIndex = endIndex + 1;
        }
        if (eolIndex == -1) {
            eolIndex = endIndex + 1;
        }
        if (encloserIndex < eolIndex && encloserIndex < endIndex) {
            return 0;
        }
        if (eolIndex < encloserIndex && eolIndex < endIndex) {
            return 1;
        }
        return 2;
    }
}

