/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.text.operation;

import com.harrand.coreclasses.element.Range;
import com.harrand.coreclasses.help.StrHelper;
import java.util.List;

public final class IndentCtrl {
    private int indentSize_;

    public IndentCtrl(int indentSize) {
        this.setIndentSize(indentSize);
    }

    public String indentText(String effectedText, Range selectionRange, int operation) {
        return this.processText(effectedText, selectionRange, operation);
    }

    public void setIndentSize(int indentSize) {
        this.indentSize_ = indentSize;
    }

    public int getIndentSize() {
        return this.indentSize_;
    }

    private String processText(String effectedText, Range selectionRange, int operation) {
        if (selectionRange.getLength() > 0) {
            return this.getSelectedTextIndent(effectedText, operation);
        }
        return this.getUnselectedTextIndent(effectedText, selectionRange.getStart(), operation);
    }

    private String getUnselectedTextIndent(String text, int indentPos, int operation) {
        StringBuffer sb = new StringBuffer();
        if (operation == 1) {
            sb.append(this.addPosIndent(text, indentPos));
        } else {
            sb.append(this.removePosIndent(text, indentPos));
        }
        return sb.toString();
    }

    private String addPosIndent(String text, int indentPos) {
        if (indentPos < 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(text);
        int nextIndentPos = this.getNextIndentPos(indentPos);
        int spacesToAdd = nextIndentPos - indentPos;
        for (int i = 0; i < spacesToAdd; ++i) {
            sb.insert(indentPos, " ");
        }
        return sb.toString();
    }

    private String removePosIndent(String text, int indentPos) {
        StringBuffer sb = new StringBuffer(text);
        int leadingSpaces = this.getLeadingSpaceCount(text);
        if (leadingSpaces >= indentPos) {
            int prevIndentPos = this.getPrevIndentPos(indentPos);
            int spacesToRemove = indentPos - prevIndentPos;
            sb.delete(0, spacesToRemove);
        }
        return sb.toString();
    }

    private String getSelectedTextIndent(String text, int operation) {
        StringBuffer sb = new StringBuffer(text.length());
        List textLines = StrHelper.splitIntoTextLines(text);
        boolean addNewLine = false;
        for (String line : textLines) {
            if (addNewLine) {
                sb.append("\n");
            }
            if (operation == 1) {
                sb.append(this.addLineIndent(line));
            } else {
                sb.append(this.removeLineIndent(line));
            }
            addNewLine = true;
        }
        return sb.toString();
    }

    private String addLineIndent(String lineText) {
        StringBuffer sb = new StringBuffer(lineText);
        int leadingSpaces = this.getLeadingSpaceCount(lineText);
        int nextIndentPos = this.getNextIndentPos(leadingSpaces);
        int spacesToAdd = nextIndentPos - leadingSpaces;
        for (int i = 0; i < spacesToAdd; ++i) {
            sb.insert(0, " ");
        }
        return sb.toString();
    }

    private String removeLineIndent(String lineText) {
        StringBuffer sb = new StringBuffer(lineText);
        int leadingSpaces = this.getLeadingSpaceCount(lineText);
        int prevIndentPos = this.getPrevIndentPos(leadingSpaces);
        int spacesToRemove = leadingSpaces - prevIndentPos;
        sb.delete(0, spacesToRemove);
        return sb.toString();
    }

    private int getNextIndentPos(int currentPos) {
        int tabs = currentPos / this.indentSize_ + 1;
        return tabs * this.indentSize_;
    }

    private int getPrevIndentPos(int currentPos) {
        int absPos = currentPos;
        int tabs = absPos / this.indentSize_;
        if (absPos % this.indentSize_ > 0) {
            ++tabs;
        }
        if (--tabs > 0) {
            return tabs * this.indentSize_;
        }
        return 0;
    }

    public int getLeadingSpaceCount(String textLine) {
        int count = 0;
        boolean isSpace = true;
        while (isSpace && count < textLine.length()) {
            char ch = textLine.charAt(count);
            if (Character.isSpaceChar(ch)) {
                ++count;
                continue;
            }
            isSpace = false;
        }
        return count;
    }
}

