/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.text.element;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;

public final class StringTriplet {
    private String key_;
    private String prompt_;
    private String defaultValue_;

    public StringTriplet(String key, String prompt, String defaultValue) {
        ITestResult result = StringTriplet.validateInput(key, prompt, defaultValue);
        if (!result.getPassed()) {
            StrHelper.throwProgExcept(result.getDetail());
        }
        this.key_ = key;
        this.prompt_ = prompt;
        this.defaultValue_ = defaultValue;
    }

    public String getKey() {
        return this.key_;
    }

    public String getPrompt() {
        return this.prompt_;
    }

    public String getDefaultValue() {
        return this.defaultValue_;
    }

    public static ITestResult validateInput(String key, String prompt, String defaultValue) {
        StringBuffer sb = new StringBuffer();
        if (key == null) {
            sb.append("StringTriplet key can not be null.");
        } else if (key.length() == 0) {
            sb.append("StringTriplet key can not be empty string.");
        }
        if (prompt == null) {
            sb.append("StringTriplet prompt can not be null.");
        } else if (prompt.length() == 0) {
            sb.append("StringTriplet prompt can not be empty string.");
        }
        boolean passed = sb.toString().length() == 0;
        DataEntryResult result = new DataEntryResult(passed, sb.toString());
        return result;
    }
}

