/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.text;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.xml.abstractions.IXmlable;
import com.harrand.util.FileHelper;
import com.harrand.util.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class Abbreviation
implements Identifiable,
IXmlable {
    private String shortText_;
    private String fullText_;
    public static final String XML_PLURAL = "Abbreviations";
    public static final String XML_SHORT_TEXT = "ShortText";
    public static final String XML_FULL_TEXT = "FullText";
    public static final String HD_SHORT_TEXT = "Short Text";
    public static final String HD_FULL_TEXT = "Full Text";

    public Abbreviation(String shortText, String fullText) {
        ITestResult result = Abbreviation.validateInput(shortText, fullText);
        if (!result.getPassed()) {
            StrHelper.throwProgExcept(result.getDetail());
        }
        this.shortText_ = shortText;
        this.fullText_ = fullText;
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element element = doc.createElement(Abbreviation.clazz());
        XmlHelper.addElementSimple(doc, element, XML_SHORT_TEXT, this.shortText_);
        XmlHelper.addElementSimple(doc, element, XML_FULL_TEXT, this.fullText_);
        return element;
    }

    public static Abbreviation fromXml(Element element) {
        String lShortText = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(element, XML_SHORT_TEXT));
        String lFullText = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(element, XML_FULL_TEXT));
        Abbreviation newAbbr = new Abbreviation(lShortText, lFullText);
        return newAbbr;
    }

    public static String clazz() {
        return "Abbreviation";
    }

    @Override
    public String getMapName() {
        return Abbreviation.clazz();
    }

    @Override
    public String getName() {
        return this.shortText_;
    }

    public String getFullText() {
        return this.fullText_;
    }

    public String getShortText() {
        return this.shortText_;
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    @Override
    public void setName(String newName) {
        StrHelper.throwProgExcept("Abbreviation does not implement setName().");
    }

    public static ITestResult validateInput(String shortText, String fullText) {
        StringBuffer sb = new StringBuffer();
        if (shortText == null) {
            sb.append(FileHelper.getRes("abbr.err.short.text.null.msg"));
        } else if (shortText.length() == 0) {
            sb.append(FileHelper.getRes("abbr.err.short.text.empty.msg"));
        }
        if (fullText == null) {
            sb.append(FileHelper.getRes("abbr.err.full.text.null.msg"));
        } else if (fullText.length() == 0) {
            sb.append(FileHelper.getRes("abbr.err.full.text.empty.msg"));
        }
        boolean passed = sb.toString().length() == 0;
        DataEntryResult result = new DataEntryResult(passed, sb.toString());
        return result;
    }
}

