/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.system;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.util.ResMgr;

public final class JvmUtil {
    public static ITestResult checkVersion(String versionStr) {
        boolean ok = false;
        boolean is17 = false;
        DataEntryResult result = null;
        if (versionStr.indexOf("1.5") == 0) {
            ok = true;
        }
        if (versionStr.indexOf("1.6") == 0) {
            ok = true;
        }
        if (versionStr.indexOf("1.7") == 0) {
            is17 = true;
            ok = false;
        }
        if (ok) {
            result = new DataEntryResult(true);
        } else {
            String title = ResMgr.getRes("jvm.invalid");
            String msgOld = ResMgr.getRes("jvm.required.1.5") + "\n" + ResMgr.getRes("jvm.version.found") + versionStr + "\n" + ResMgr.getRes("jvm.download.free.at");
            String msgBeta = "Java 1.7 is not supported at this time. \nIt will be supported after it's beta cycle is completed.\nJava 1.5 and 1.6 are supported.";
            String msg = is17 ? msgBeta : msgOld;
            result = new DataEntryResult(false, title, msg);
        }
        return result;
    }

    public static String getVersionStr() {
        return System.getProperty("java.version");
    }

    public static boolean isJava17(String verStr) {
        boolean isVersion = false;
        if (verStr.indexOf("1.7") >= 0) {
            isVersion = true;
        }
        return isVersion;
    }
}

