/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.security;

import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.xml.abstractions.IXmlable;
import com.harrand.util.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class Code
implements Identifiable,
IXmlable {
    private String text_;
    private int typeId_;
    public static final int TYPE_STANDARD_ID = 0;
    public static final int TYPE_UPGRADE_ID = 1;
    public static final String NAME_XML = "License";
    public static final String TYPE_XML = "Type";
    public static final String TEXT_XML = "Text";

    @Deprecated
    public Code(String text) {
        this.text_ = text;
        this.typeId_ = 0;
    }

    public Code(String text_, int typeId_) {
        this.text_ = text_;
        this.typeId_ = typeId_;
    }

    public String getText() {
        return this.text_;
    }

    public int getTypeId() {
        return this.typeId_;
    }

    public static Code fromXml(Element element) {
        int typeId = element.hasAttribute(TYPE_XML) ? XmlHelper.getAttrInt(element, TYPE_XML) : 0;
        String text = XmlHelper.getFirstElementValue(element, TEXT_XML);
        return new Code(text, typeId);
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element element = doc.createElement(NAME_XML);
        XmlHelper.addElementSimple(doc, element, TEXT_XML, this.getText());
        XmlHelper.setAttr(element, TYPE_XML, this.typeId_);
        return element;
    }

    public static String clazz() {
        return "Code";
    }

    @Override
    public String getMapName() {
        return Code.clazz();
    }

    @Override
    public String getName() {
        return this.text_;
    }

    @Override
    public void setName(String newName) {
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    public boolean isStandard() {
        return this.getTypeId() == 0;
    }

    public boolean isUpgrade() {
        return this.getTypeId() == 1;
    }

    public String toString() {
        return "Code: " + this.getText() + ", typdId: " + this.getTypeId();
    }
}

