/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.security;

import com.harrand.coreclasses.security.ILogin;
import com.harrand.coreclasses.security.IPasswordCipher;
import com.harrand.util.FileHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public final class BasicPasswordCipher
implements IPasswordCipher {
    private Cipher cipher_;
    private SecretKey pbeKey_;
    private PBEParameterSpec pbeParamSpec_;
    private byte[] salt_ = new byte[]{126, -56, -61, 115, -18, -106, 33, -116};
    private int count_ = 21;
    public static final String HASH_KEY = "dbWrench0.1";

    public BasicPasswordCipher(ILogin login) throws Exception {
        this.setupCipher(login);
    }

    private void setupCipher(ILogin login) throws Exception {
        String str = HASH_KEY + new String(login.getPassword());
        char[] chars = str.toCharArray();
        PBEKeySpec pbeKeySpec = new PBEKeySpec(chars);
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
        this.pbeParamSpec_ = new PBEParameterSpec(this.salt_, this.count_);
        this.pbeKey_ = keyFac.generateSecret(pbeKeySpec);
        this.cipher_ = Cipher.getInstance("PBEWithMD5AndDES");
    }

    private void setCipherMode(int mode) throws Exception {
        this.cipher_.init(mode, (Key)this.pbeKey_, this.pbeParamSpec_);
    }

    @Override
    public String decrypt(byte[] bytes) throws Exception {
        this.setCipherMode(2);
        return new String(this.cipher_.doFinal(bytes));
    }

    @Override
    public byte[] encrypt(String clearText) throws Exception {
        this.setCipherMode(1);
        return this.cipher_.doFinal(clearText.getBytes());
    }

    @Override
    public String readEncrypted(File file) throws Exception {
        this.setCipherMode(2);
        byte[] decrypted = this.cipher_.doFinal(FileHelper.readBytes(file));
        return new String(decrypted);
    }

    @Override
    public void setPassword(ILogin login) throws Exception {
        this.setupCipher(login);
    }

    @Override
    public void writeEncrypted(String clearText, File file) throws Exception {
        this.setCipherMode(1);
        FileOutputStream fos = new FileOutputStream(file);
        CipherOutputStream cos = new CipherOutputStream(fos, this.cipher_);
        FileHelper.writeBytes(cos, clearText.getBytes());
        cos.close();
        fos.close();
    }
}

