/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.security;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.security.ILogin;
import com.harrand.coreclasses.xml.abstractions.IXmlable;
import com.harrand.util.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class BasicLogin
implements ILogin,
IXmlable {
    private String userName_;
    private char[] password_;
    private static BasicLogin defautLogin__ = new BasicLogin("DefaultUser", "".toCharArray());
    public static BasicLogin testLogin__ = new BasicLogin("TestUser", "".toCharArray());
    private static final String XML_USERNAME = "UserName";

    public BasicLogin(String userName, char[] password) {
        this.validateInput(userName, password);
        this.userName_ = userName;
        this.password_ = password;
    }

    public static BasicLogin getDefautLogin() {
        return defautLogin__;
    }

    public static BasicLogin getTestLogin() {
        return testLogin__;
    }

    @Override
    public String getUserName() {
        return this.userName_;
    }

    @Override
    public char[] getPassword() {
        return this.password_;
    }

    @Override
    public void clearPassword() {
        this.password_ = new char[0];
    }

    private void validateInput(String userName, char[] password) {
        try {
            if (userName == null) {
                throw new Exception("userName can not be null for BasicLogin.");
            }
            if (password == null) {
                throw new Exception("password can not be null for BasicLogin.");
            }
        }
        catch (Exception e) {
            System.out.println("Error Msg: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public String getMapName() {
        return BasicLogin.clazz();
    }

    public static String clazz() {
        return "BasicLogin";
    }

    @Override
    public String getName() {
        return this.userName_;
    }

    @Override
    public void setName(String newName) {
        StrHelper.throwProgrammingException("BasicLogin.setName() not implemented");
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element element = doc.createElement(BasicLogin.clazz());
        XmlHelper.addElementSimple(doc, element, XML_USERNAME, this.userName_);
        return element;
    }

    public static BasicLogin fromXml(Element element) {
        String userName = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(element, XML_USERNAME));
        return new BasicLogin(userName, "".toCharArray());
    }
}

