/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.security;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.security.Code;
import com.harrand.coreclasses.security.ICodeMgr;
import com.harrand.util.ResMgr;
import com.harrand.util.Validator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

public final class BasicCodeMgr
implements ICodeMgr {
    private List codes_;
    private Calendar calInstall_;
    private int trialLength_;

    public BasicCodeMgr(List codes, Calendar calInstall, int trialLength) {
        this.codes_ = new ArrayList(codes);
        this.calInstall_ = calInstall;
        this.trialLength_ = trialLength;
    }

    @Override
    public ITestResult checkValid(Code code) {
        ITestResult result = this.validateCode(code);
        if (!result.getPassed()) {
            result = new DataEntryResult(this.isTrialValid());
        }
        return result;
    }

    @Override
    public int getValidateId(Code code) {
        int id = 0;
        if (this.validateCode(code).getPassed()) {
            id = 2;
        } else if (this.isTrialValid()) {
            id = 1;
        }
        return id;
    }

    @Override
    public ITestResult validateCode(Code code) {
        String text = code.getText();
        DataEntryResult result = null;
        if (this.contains(code)) {
            String msg = StrHelper.replaceWildCard(ResMgr.getRes("license.invalid.msg"), text);
            result = new DataEntryResult(true, ResMgr.getRes("license.validated.msg"));
        } else {
            String msg = StrHelper.replaceWildCard(ResMgr.getRes("license.invalid.msg"), text);
            result = new DataEntryResult(false, ResMgr.getRes("license.invalid.title"), msg);
        }
        return result;
    }

    private boolean contains(Code code) {
        boolean found = false;
        String text = code.getText();
        if (Validator.isStringValid(text)) {
            found = this.codes_.contains(text);
        }
        return found;
    }

    @Override
    public String getValidateDesc(Code code, int id) {
        String msg = "";
        String desc = "";
        String trialLengthStr = Integer.toString(this.trialLength_);
        switch (id) {
            case 0: {
                msg = ResMgr.getRes("license.trial.expired.msg");
                desc = StrHelper.replaceWildCard(msg, trialLengthStr);
                break;
            }
            case 1: {
                msg = ResMgr.getRes("license.trial.remaining.msg");
                desc = StrHelper.replaceWildCards(msg, new String[]{trialLengthStr, Integer.toString(this.getTrialDaysRemaining())});
                break;
            }
            case 2: {
                desc = ResMgr.getRes("license.standard.label") + " (" + ResMgr.getRes("license.key.label") + ": " + code.getText() + ")";
                break;
            }
            default: {
                StrHelper.throwProgExcept("Unsupported ValidateId: " + id);
            }
        }
        return desc;
    }

    public boolean isTrialValid() {
        boolean valid = false;
        int daysRemain = this.getTrialDaysRemaining();
        if (daysRemain > 0 && daysRemain <= this.trialLength_) {
            valid = true;
        }
        return valid;
    }

    public int getTrialDaysRemaining() {
        long msInstall;
        Calendar today = GregorianCalendar.getInstance();
        long msToday = today.getTimeInMillis();
        long msInstalled = msToday - (msInstall = this.calInstall_.getTimeInMillis());
        long daysInstalled = msInstalled / 86400000L;
        int daysLeft = this.trialLength_ - (int)daysInstalled;
        if (daysLeft < 0) {
            daysLeft = 0;
        }
        return daysLeft;
    }
}

