/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.script.text;

import com.harrand.coreclasses.interfaces.IScript;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.util.Validator;

public class ScriptTextBldr {
    private StringBuilder sb;

    public String asText(IScript script) {
        this.sb = new StringBuilder();
        this.breakdownScript(script);
        return this.sb.toString().trim();
    }

    public String asText(IStep step) {
        if (step instanceof IScript) {
            return this.asText((IScript)step);
        }
        return (String)step.getExecuteObject();
    }

    private void appendSemiColon() {
        String endStr;
        int length = this.sb.length();
        if (length > 3 && !(endStr = this.sb.substring(length - 2, length - 1)).equals(";")) {
            this.sb.append(";\n");
        }
    }

    private void breakdownScript(IScript script) {
        this.processScript(script);
        for (IStep step : script.values()) {
            if (step instanceof IScript) {
                this.breakdownScript((IScript)step);
                continue;
            }
            this.processText(step);
        }
        this.postProcessScript(script);
    }

    private void processText(IStep step) {
        String comment = step.getComment();
        if (Validator.isStringValid(comment)) {
            this.sb.append(this.formatComment(comment, false));
        }
        String cmdText = (String)step.getExecuteObject();
        this.sb.append(cmdText);
        this.appendSemiColon();
        if (!step.getOmitLineFeed()) {
            this.sb.append("\n");
        }
    }

    private void processScript(IScript script) {
        if (Validator.isStringValid(script.getComment())) {
            this.sb.append(this.formatComment(script.getComment(), true));
        }
    }

    private void postProcessScript(IScript script) {
        this.sb.append("\n");
    }

    private String formatComment(String cmm, boolean isScriptCmm) {
        String preDelimit = cmm.indexOf("/*") >= 0 ? "" : "/* ";
        String postDelimit = cmm.indexOf("*/") >= 0 ? "" : " */";
        StringBuilder sb = new StringBuilder(preDelimit + cmm + postDelimit + "\n");
        if (isScriptCmm) {
            sb.append("\n");
        }
        return sb.toString();
    }
}

