/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.script.bldr;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.script.IScriptBuilder;
import com.harrand.dbwrench.script.builder.ScriptUtil;
import com.harrand.util.ResMgr;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class IdfStepsBldr {
    public IScriptBuilder scriptBldr;
    private String mapNm;
    private boolean caseSens;
    private List<IStep> removeSteps;
    private List<IStep> addSteps;
    private String removeCmm;
    private String addCmm;

    public IdfStepsBldr(IScriptBuilder scriptBldr, String mapNm, boolean caseSens) {
        this.scriptBldr = scriptBldr;
        this.mapNm = mapNm;
        this.caseSens = caseSens;
    }

    public void refreshSteps(Collector oldColl, Collector newColl, boolean parentRebuilt) {
        this.clearLists();
        this.initCmms(newColl);
        List newNames = StrHelper.checkLowerCaseSet(this.caseSens, newColl.getKeys(this.mapNm));
        List oldNames = parentRebuilt ? new ArrayList() : StrHelper.checkLowerCaseSet(this.caseSens, oldColl.getKeys(this.mapNm));
        TreeSet allNames = new TreeSet(oldNames);
        allNames.addAll(newNames);
        for (String name : allNames) {
            Identifiable newIdf;
            Identifiable oldIdf = oldNames.contains(name) ? oldColl.get(this.mapNm, name) : null;
            Identifiable identifiable = newIdf = newNames.contains(name) ? newColl.get(this.mapNm, name) : null;
            if (oldIdf == null) {
                this.addIfNotNull(this.addSteps, this.getStep(oldIdf, newIdf));
                continue;
            }
            if (newIdf == null) {
                this.addIfNotNull(this.removeSteps, this.getStep(oldIdf, newIdf));
                continue;
            }
            if (!this.scriptBldr.needsUpdate(oldIdf, newIdf)) continue;
            this.addIfNotNull(this.removeSteps, this.getStep(oldIdf, null));
            this.addIfNotNull(this.addSteps, this.getStep(null, newIdf));
        }
    }

    private IStep getStep(Identifiable oldIdf, Identifiable newIdf) {
        return this.scriptBldr.getStep(oldIdf, newIdf);
    }

    private void addIfNotNull(List<IStep> steps, IStep step) {
        ScriptUtil.addIfNotNull(steps, step);
    }

    private String getRes(String label) {
        this.setFirstStepCmm(this.addSteps, this.addCmm);
        return ResMgr.getRes(label);
    }

    public List<IStep> getAddSteps() {
        this.setFirstStepCmm(this.addSteps, this.addCmm);
        return this.addSteps;
    }

    public List<IStep> getRemoveSteps() {
        this.setFirstStepCmm(this.removeSteps, this.removeCmm);
        return this.removeSteps;
    }

    private void clearLists() {
        this.removeSteps = new ArrayList<IStep>();
        this.addSteps = new ArrayList<IStep>();
    }

    private void initCmms(Collector coll) {
        String itemPluralNm = coll.getDisplayPlural(this.mapNm);
        this.removeCmm = this.getRes("remove.label") + " " + itemPluralNm;
        this.addCmm = this.getRes("add.label") + " " + itemPluralNm;
    }

    private void setFirstStepCmm(List<IStep> steps, String cmm) {
        if (!steps.isEmpty()) {
            IStep firstStep = steps.get(0);
            firstStep.setComment(cmm);
        }
    }
}

