/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.rename;

import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.rename.Rename;
import com.harrand.coreclasses.rename.RenameChain;
import com.harrand.coreclasses.rename.RenameContext;
import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RenameMgr
implements IObservable {
    private int nextRenameId_ = 1;
    private BasicObservable observable_;
    private List chains_ = new ArrayList();
    public static final String RNM_MGR_XML = "RnmMgr";
    public static final String NEXT_RNM_ID_XML = "NxRnmId";

    public RenameMgr() {
        this(1, new ArrayList());
    }

    public RenameMgr(int nextRnmId, List chains) {
        this.observable_ = new BasicObservable();
        this.nextRenameId_ = nextRnmId;
        this.chains_ = chains;
    }

    public void addRename(Rename rename, RenameContext ctx) {
        boolean added = false;
        Iterator it = this.chains_.iterator();
        while (!added && it.hasNext()) {
            RenameChain chain = (RenameChain)it.next();
            boolean canAdd = chain.canAddRename(ctx, rename);
            if (!canAdd) continue;
            chain.addRename(rename);
            added = true;
        }
        if (!added) {
            RenameChain newChain = new RenameChain(ctx);
            newChain.addRename(rename);
            this.chains_.add(newChain);
        }
        this.checkParentRename(rename, ctx);
        this.notifyObservers(null);
    }

    public void removeChain(RenameChain chain) {
        this.chains_.remove(chain);
        this.notifyObservers(null);
    }

    public void removeRename(int renameId) {
        for (RenameChain chain : this.chains_) {
            ArrayList<Rename> removeList = new ArrayList<Rename>();
            for (Rename rnm : chain.getRenames()) {
                int rnmFromChainId = rnm.getId();
                if (renameId != rnm.getId()) continue;
                removeList.add(rnm);
            }
            for (Rename rnmRemove : removeList) {
                chain.removeRename(rnmRemove);
            }
        }
        this.removeEmptyChains();
        this.notifyObservers(null);
    }

    private void removeEmptyChains() {
        ArrayList<RenameChain> emptyChains = new ArrayList<RenameChain>();
        for (RenameChain chain : this.chains_) {
            if (chain.getRenames().size() != 0) continue;
            emptyChains.add(chain);
        }
        for (RenameChain chain : emptyChains) {
            this.chains_.remove(chain);
        }
    }

    private void checkParentRename(Rename newRename, RenameContext ctx) {
        if (ctx.getParentNm() == null) {
            return;
        }
        for (RenameChain chain : this.chains_) {
            if (!chain.getParentNeedsRename(newRename, ctx)) continue;
            chain.setParentName(newRename.getNewName());
        }
    }

    private List getMatchingChains(RenameContext ctx) {
        ArrayList<RenameChain> matchingChains = new ArrayList<RenameChain>();
        for (RenameChain chain : this.chains_) {
            if (!chain.isContextSame(ctx)) continue;
            matchingChains.add(chain);
        }
        return matchingChains;
    }

    public List getRenameMatches(RenameContext context, List oldNames, List newNames, boolean caseSensi) {
        ArrayList<Rename> renameMatches = new ArrayList<Rename>();
        ArrayList newNamesOnly = new ArrayList(newNames);
        newNamesOnly.removeAll(oldNames);
        ArrayList oldNamesOnly = new ArrayList(oldNames);
        oldNamesOnly.removeAll(newNames);
        List chains = this.getMatchingChains(context);
        for (RenameChain chain : chains) {
            Iterator itNewNames = newNamesOnly.iterator();
            while (itNewNames.hasNext()) {
                String newName;
                String latestName = caseSensi ? chain.getLatestName() : chain.getLatestName().toLowerCase();
                if (!latestName.equals(newName = (String)itNewNames.next())) continue;
                for (String oldName : oldNamesOnly) {
                    Rename rnmCandidate = chain.getRenameCandidate(oldName, caseSensi);
                    if (rnmCandidate == null) continue;
                    renameMatches.add(rnmCandidate);
                }
            }
        }
        return renameMatches;
    }

    public int getNextRenameId() {
        return this.nextRenameId_++;
    }

    public List getRenameChains() {
        return this.chains_;
    }

    public RenameChain getRenameChain(String chainName) {
        for (RenameChain chain : this.chains_) {
            if (!chainName.equals(chain.getName())) continue;
            return chain;
        }
        return null;
    }

    public Element asXmlElement(Document doc) {
        Element elmMgr = doc.createElement(RNM_MGR_XML);
        XmlHelper.setAttr(elmMgr, NEXT_RNM_ID_XML, this.nextRenameId_);
        for (RenameChain chain : this.getRenameChains()) {
            Element elmChain = chain.asXmlElement(doc);
            elmMgr.appendChild(elmChain);
        }
        return elmMgr;
    }

    public static RenameMgr fromXml(Element elmMgr) {
        int nextRnmId = XmlHelper.getAttrInt(elmMgr, NEXT_RNM_ID_XML);
        ArrayList<RenameChain> newChains = new ArrayList<RenameChain>();
        NodeList nl = elmMgr.getElementsByTagName("RnmCh");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element elmChain = (Element)nl.item(i);
            newChains.add(RenameChain.fromXml(elmChain));
        }
        RenameMgr newMgr = new RenameMgr(nextRnmId, newChains);
        return newMgr;
    }

    public static boolean wasRenamed(List renameMatches, String oldName, boolean caseSensi) {
        String newName = RenameMgr.getMatchingNewName(renameMatches, oldName, caseSensi);
        return newName != null;
    }

    public static String getMatchingNewName(List renameMatches, String oldName, boolean caseSensi) {
        boolean found = false;
        String newName = null;
        Iterator it = renameMatches.iterator();
        while (!found && it.hasNext()) {
            Rename rnm = (Rename)it.next();
            found = caseSensi ? oldName.equals(rnm.getOldName()) : oldName.equalsIgnoreCase(rnm.getOldName());
            if (!found) continue;
            newName = rnm.getNewName();
        }
        return newName;
    }

    public static boolean isARename(List renameMatches, String newName, boolean caseSensi) {
        boolean found = false;
        Iterator it = renameMatches.iterator();
        while (!found && it.hasNext()) {
            Rename rnm = (Rename)it.next();
            if (caseSensi) {
                found = newName.equals(rnm.getNewName());
                continue;
            }
            found = newName.equalsIgnoreCase(rnm.getNewName());
        }
        return found;
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }
}

