/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.rename;

import com.harrand.util.LogUtil;
import com.harrand.util.MathUtil;
import com.harrand.util.Validator;

public class RenameContext {
    private String objClassNm_ = "";
    private String parentNm_ = null;
    private String parentClassNm_ = null;
    private String superCollectorClassNm_ = null;
    private String superCollectorNm_ = null;

    public RenameContext(String objClassNm, String parentNm, String parentClassNm, String superCollectorNm, String superCollectorClassNm) {
        this.objClassNm_ = objClassNm;
        this.parentNm_ = parentNm;
        this.parentClassNm_ = parentClassNm;
        this.superCollectorClassNm_ = superCollectorClassNm;
        this.superCollectorNm_ = superCollectorNm;
        this.validateInput();
    }

    public boolean equals(Object o) {
        String superClsNm;
        String superNm;
        String parCls;
        String parNm;
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenameContext)) {
            return false;
        }
        RenameContext other = (RenameContext)o;
        if (!other.getObjClassNm().equals(this.getObjClassNm())) {
            return false;
        }
        String oParNm = other.getParentNm();
        if (MathUtil.compareNullables(oParNm, parNm = this.getParentNm()) != 0) {
            return false;
        }
        String oParCls = other.getParentClassNm();
        if (MathUtil.compareNullables(oParCls, parCls = this.getParentClassNm()) != 0) {
            return false;
        }
        String oSuperNm = other.getSuperCollectorNm();
        if (MathUtil.compareNullables(oSuperNm, superNm = this.getSuperCollectorNm()) != 0) {
            return false;
        }
        String oSuperClsNm = other.getSuperCollectorNm();
        return MathUtil.compareNullables(oSuperClsNm, superClsNm = this.getSuperCollectorNm()) == 0;
    }

    public String getParentDisplayNm() {
        StringBuffer sb = new StringBuffer();
        if (this.superCollectorNm_ != null) {
            sb.append(this.superCollectorNm_ + ".");
        }
        sb.append(this.getParentNm());
        return sb.toString();
    }

    public void setParentNm(String parentNm) {
        this.parentNm_ = parentNm;
    }

    public String getObjClassNm() {
        return this.objClassNm_;
    }

    public String getParentNm() {
        return this.parentNm_;
    }

    public String getParentClassNm() {
        return this.parentClassNm_;
    }

    public String getSuperCollectorNm() {
        return this.superCollectorNm_;
    }

    public String getSuperCollectorClass() {
        return this.superCollectorClassNm_;
    }

    private void validateInput() {
        boolean parentClassNmValid;
        boolean parentNmValid = Validator.isStringValid(this.parentNm_);
        if (parentNmValid != (parentClassNmValid = Validator.isStringValid(this.parentClassNm_))) {
            LogUtil.logErr("RenameContext. Both the parent name and the parentclass must be provided or neither.");
        }
    }

    public String toString() {
        String parClsStr = this.getParentClassNm() != null ? this.getParentClassNm() : "null";
        String parNmStr = this.getParentNm() != null ? this.getParentNm() : "null";
        return "RenameCtx: ObjCls: " + this.getObjClassNm() + ", parCls:" + parClsStr + ", parNm:" + parNmStr;
    }
}

