/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.option;

import com.harrand.coreclasses.option.IOption;
import com.harrand.coreclasses.xml.abstractions.IXmlable;
import com.harrand.util.FileHelper;
import com.harrand.util.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TextOption
implements IOption,
IXmlable {
    private String name;
    private String label;
    private String value;
    public static final String XML_CLZ = "TextOpt";

    public TextOption(String name_, String value_) {
        this.name = name_;
        this.value = value_;
        this.setResourceLabel();
    }

    private void setResourceLabel() {
        String resourceLabel = FileHelper.getResUnkown(this.name + ".label");
        this.label = resourceLabel != null ? resourceLabel : this.getLabelError();
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element elm = XmlHelper.createElementSimple(doc, XML_CLZ, this.value);
        elm.setAttribute("nm", this.getName());
        return elm;
    }

    public static TextOption fromXml(Element elm) {
        String lName = elm.getAttribute("nm");
        String lValue = XmlHelper.getElementValue(elm);
        TextOption newOption = new TextOption(lName, lValue);
        return newOption;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getMapName() {
        return TextOption.clazz();
    }

    public static String clazz() {
        return "TextOption";
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    private String getLabelError() {
        return "Error loading label text: " + this.name + ".label";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = this.name;
    }
}

