/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.option;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.option.BooleanOption;
import com.harrand.coreclasses.option.IOption;
import com.harrand.coreclasses.xml.abstractions.IXmlable;
import com.harrand.util.FileHelper;
import com.harrand.util.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class IntegerOption
implements IOption,
IXmlable {
    private String name_;
    private String label_;
    private int value_;
    public static final String XML_OLD_CLZ = "IntegerOption";
    public static final String XML_CLZ = "IntOpt";

    public IntegerOption(String name, int value) {
        if (name == null) {
            StrHelper.throwProgExcept("Name can not be null for " + IntegerOption.clazz());
        }
        this.name_ = name;
        this.value_ = value;
        this.setResourceLabel();
    }

    private void setResourceLabel() {
        String resourceLabel = FileHelper.getResUnkown(this.name_ + ".label");
        this.label_ = resourceLabel != null ? resourceLabel : this.getLabelError();
    }

    private String getLabelError() {
        return "Error loading label text: " + this.name_ + ".label";
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element elm = doc.createElement(XML_CLZ);
        elm.setAttribute("nm", this.getName());
        XmlHelper.setAttr(elm, "val", this.value_);
        elm.setAttribute("lbl", this.getLabel());
        return elm;
    }

    public static IntegerOption fromXml(Element elm) {
        String lName = elm.getAttribute("nm");
        String lLabel = BooleanOption.getResourceLabel(lName);
        int lValue = XmlHelper.getAttrInt(elm, "val");
        IntegerOption newOption = new IntegerOption(lName, lValue);
        return newOption;
    }

    public static IntegerOption fromXmlPre141(Element element) {
        String lName = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(element, "Name"));
        int lValue = XmlHelper.getElementValueInt(XmlHelper.getFirstElementByTagName(element, "Value"));
        IntegerOption newOption = new IntegerOption(lName, lValue);
        return newOption;
    }

    @Override
    public String getLabel() {
        return this.label_;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    public int getValue() {
        return this.value_;
    }

    @Override
    public String getMapName() {
        return IntegerOption.clazz();
    }

    public static String clazz() {
        return XML_OLD_CLZ;
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    @Override
    public void setName(String newName) {
        StrHelper.throwProgExcept(IntegerOption.clazz() + " does not implement setName().");
    }
}

