/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.option;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.option.IOption;
import com.harrand.coreclasses.xml.abstractions.IXmlable;
import com.harrand.util.FileHelper;
import com.harrand.util.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class BooleanOption
implements IOption,
IXmlable {
    private String name_;
    private String label_;
    private boolean value_;
    private boolean specifiedLabel_;
    public static final String XML_OLD_CLZ = "BooleanOption";
    public static final String XML_CLZ = "BoolOpt";
    public static final String XML_SPECIFIED_LBL = "spl";

    public BooleanOption(String name, boolean value) {
        String label;
        if (name == null) {
            StrHelper.throwProgExcept("Name can not be null for " + BooleanOption.clazz());
        }
        if ((label = BooleanOption.getResourceLabel(name)) == null) {
            label = this.getLabelError();
        }
        this.setValues(name, label, value, false);
    }

    public BooleanOption(String name, String label, boolean value) {
        if (name == null) {
            StrHelper.throwProgExcept("Name can not be null for " + BooleanOption.clazz());
        }
        this.setValues(name, label, value, true);
    }

    private void setValues(String name, String label, boolean value, boolean specifiedLabel) {
        this.name_ = name;
        this.value_ = value;
        this.label_ = label;
        this.specifiedLabel_ = specifiedLabel;
    }

    public static String getResourceLabel(String name) {
        String resLabel = FileHelper.getResUnkown(name + ".label");
        return resLabel;
    }

    private String getLabelError() {
        return "Error loading label text: " + this.name_ + ".label";
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element elm = doc.createElement(XML_CLZ);
        elm.setAttribute("nm", this.getName());
        elm.setAttribute("lbl", this.getLabel());
        XmlHelper.setAttrBoolAsInt(elm, "on", this.getValue());
        XmlHelper.setAttrBoolAsInt(elm, XML_SPECIFIED_LBL, this.getSpecifiedLabel());
        return elm;
    }

    public static BooleanOption fromXml(Element elm) {
        String lName = elm.getAttribute("nm");
        String lLabel = BooleanOption.getResourceLabel(lName);
        boolean lValue = XmlHelper.getAttrBoolFromInt(elm, "on");
        boolean lSpecified = XmlHelper.getAttrBoolFromInt(elm, XML_SPECIFIED_LBL);
        BooleanOption newOpt = lSpecified ? new BooleanOption(lName, lLabel, lValue) : new BooleanOption(lName, lValue);
        return newOpt;
    }

    public static BooleanOption fromXmlPre140(Element element) {
        String lName = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(element, "Name"));
        boolean lValue = XmlHelper.getElementValueBoolean(XmlHelper.getFirstElementByTagName(element, "Value"));
        BooleanOption newOption = new BooleanOption(lName, lValue);
        return newOption;
    }

    @Override
    public String getLabel() {
        return this.label_;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    public boolean getValue() {
        return this.value_;
    }

    @Override
    public String getMapName() {
        return BooleanOption.clazz();
    }

    public boolean getSpecifiedLabel() {
        return this.specifiedLabel_;
    }

    public static String clazz() {
        return XML_OLD_CLZ;
    }

    @Override
    public void setName(String newName) {
        StrHelper.throwProgExcept(BooleanOption.clazz() + " does not implement setName().");
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }
}

