/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.notification;

import com.harrand.coreclasses.interfaces.INamed;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class BasicObservable
implements IObservable {
    private List observers_ = new Vector();
    private String superDesc_ = "";

    public void setSuperDesc(String desc) {
        this.superDesc_ = desc;
    }

    public String getSuperDesc() {
        return this.superDesc_;
    }

    public List getObservers() {
        return new ArrayList(this.observers_);
    }

    public String getObserverDescs() {
        StringBuffer sb = new StringBuffer();
        for (Object obj : this.observers_) {
            String desc = this.getObserverDesc(obj);
            sb.append(desc).append("; ");
        }
        return sb.toString();
    }

    private String getObserverDesc(Object obj) {
        String clzNm = obj instanceof Identifiable ? ((Identifiable)obj).getMapName() : "";
        String nm = obj instanceof INamed ? ((INamed)obj).getName() : obj.toString();
        String desc = clzNm + ": " + nm;
        return desc;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Observer: ");
        Iterator it = this.observers_.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append(", ");
        }
        return sb.toString();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observers_.add(observer);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observers_.remove(observer);
    }

    @Override
    public void removeAllObservers() {
        this.observers_.clear();
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        ArrayList observersDup = new ArrayList(this.observers_);
        for (Object obj : observersDup) {
            IObserver anIObserver = (IObserver)obj;
            anIObserver.update(chain);
        }
    }

    @Override
    public int getObserverCount() {
        return this.observers_.size();
    }
}

