/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.list;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.INamed;
import com.harrand.coreclasses.interfaces.ITestResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NamedList {
    private List items_ = new ArrayList();

    public NamedList() {
    }

    public NamedList(NamedList list) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            INamed named = (INamed)it.next();
            this.items_.add(named);
        }
    }

    public ITestResult add(INamed named) {
        ITestResult chkRslt = this.checkDup(named);
        if (chkRslt.getPassed()) {
            this.items_.add(named);
        }
        return chkRslt;
    }

    public void add(int index, INamed named) {
        this.items_.add(index, named);
    }

    public void addAll(List namedObjs) {
        for (INamed named : namedObjs) {
            this.add(named);
        }
    }

    public int indexOf(INamed item) {
        return this.items_.indexOf(item);
    }

    public ITestResult moveUp(INamed item) {
        DataEntryResult result = new DataEntryResult(true);
        int currentPos = this.indexOf(item);
        if (currentPos == 0) {
            return new DataEntryResult(false, "Invalid Selection", "The first item can not be moved up any further.");
        }
        this.remove(item.getName());
        this.add(currentPos - 1, item);
        return result;
    }

    public ITestResult moveDown(INamed item) {
        DataEntryResult result = new DataEntryResult(true);
        int currentPos = this.indexOf(item);
        if (currentPos == this.size() - 1) {
            return new DataEntryResult(false, "Invalid Selection", "The last item can not be moved down any further.");
        }
        this.remove(item.getName());
        this.add(currentPos + 1, item);
        return result;
    }

    public void remove(String name) {
        int itemIndex = -1;
        for (int i = 0; i < this.size() && itemIndex < 0; ++i) {
            INamed named = (INamed)this.items_.get(i);
            String itemNm = named.getName();
            if (!itemNm.equalsIgnoreCase(name)) continue;
            itemIndex = i;
        }
        if (itemIndex >= 0) {
            this.items_.remove(itemIndex);
        }
    }

    public INamed get(String name) {
        INamed item = null;
        Iterator it = this.items_.iterator();
        while (item == null && it.hasNext()) {
            INamed named = (INamed)it.next();
            String itemNm = named.getName();
            if (!itemNm.equalsIgnoreCase(name)) continue;
            item = named;
        }
        return item;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (INamed named : this.items_) {
            String itemNm = named.getName();
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(itemNm);
        }
        return sb.toString();
    }

    public List getNames() {
        ArrayList<String> nms = new ArrayList<String>();
        for (INamed named : this.items_) {
            nms.add(named.getName());
        }
        return nms;
    }

    public boolean contains(String name) {
        boolean found = false;
        Iterator it = this.getNames().iterator();
        while (it.hasNext() && !found) {
            String nmUsed = (String)it.next();
            if (!nmUsed.equalsIgnoreCase(name)) continue;
            found = true;
        }
        return found;
    }

    public List asList() {
        return new ArrayList(this.items_);
    }

    public int size() {
        return this.items_.size();
    }

    public boolean isEmpty() {
        return this.items_.isEmpty();
    }

    public Iterator iterator() {
        return this.items_.iterator();
    }

    public Object get(int index) {
        return this.items_.get(index);
    }

    private ITestResult checkDup(INamed named) {
        DataEntryResult result = new DataEntryResult(true);
        String newNm = named.getName();
        for (INamed testNamed : this.items_) {
            String testNm = testNamed.getName();
            if (!testNm.equalsIgnoreCase(newNm)) continue;
            String msg = "'" + newNm + "' already added. Duplicates not allowed.";
            result = new DataEntryResult(false, "Attempting to Add Duplicate", msg);
            return result;
        }
        return result;
    }
}

