/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.list;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.list.IHistoryListSrv;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public final class BasicHistoryListSrv
implements IHistoryListSrv {
    private static BasicHistoryListSrv ref__ = new BasicHistoryListSrv();
    private Collection findHistory_;
    private Collection replaceHistory_;
    private BasicObservable observable_ = new BasicObservable();

    public BasicHistoryListSrv() {
        Comparator comparator = String.CASE_INSENSITIVE_ORDER;
        this.findHistory_ = new TreeSet(comparator);
        this.replaceHistory_ = new TreeSet(comparator);
    }

    public static BasicHistoryListSrv instance() {
        return ref__;
    }

    @Override
    public void addItem(int listId, Object item) {
        switch (listId) {
            case 0: {
                this.findHistory_.add(item);
                this.notifyObservers(new UpdateChain(item));
                break;
            }
            case 1: {
                this.replaceHistory_.add(item);
                this.notifyObservers(new UpdateChain(item));
                break;
            }
            default: {
                StrHelper.throwProgExcept("BasicHistoryListSrvp.addItem does not recognize id: " + listId);
            }
        }
    }

    @Override
    public List getList(int listId) {
        switch (listId) {
            case 0: {
                return new ArrayList(this.findHistory_);
            }
            case 1: {
                return new ArrayList(this.replaceHistory_);
            }
        }
        StrHelper.throwProgExcept("BasicHistoryListSrvp.getList does not recognize id: " + listId);
        return new ArrayList();
    }

    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }
}

