/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.jdbc;

import com.harrand.coreclasses.db.DbConfig;
import com.harrand.util.FileHelper;
import com.harrand.util.Validator;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public final class JdbcCtrl {
    private static String url_;
    private static String driverClassName_;

    private JdbcCtrl() {
    }

    public static Connection getConnection(DbConfig dbConfig) throws SQLException {
        JdbcCtrl.setDriverClassName(dbConfig.getDriverName());
        JdbcCtrl.setUrl(dbConfig.getConnectionString());
        if (!Validator.isStringValid(dbConfig.getUserName())) {
            return DriverManager.getConnection(url_);
        }
        return DriverManager.getConnection(url_, dbConfig.getUserName(), dbConfig.getPassword());
    }

    public static int executeUpdate(Connection conn, String sql) throws Exception {
        Statement stmt = conn.createStatement();
        int result = stmt.executeUpdate(sql);
        return result;
    }

    public static int executeUpdate(DbConfig dbConfig, String sql) throws Exception {
        int result = -1;
        Connection conn = null;
        String errMsg = null;
        try {
            conn = JdbcCtrl.getConnection(dbConfig);
            result = JdbcCtrl.executeUpdate(conn, sql);
        }
        catch (Exception e) {
            errMsg = e.getMessage();
        }
        if (conn != null) {
            JdbcCtrl.close(conn);
        }
        if (errMsg != null) {
            throw new Exception(errMsg);
        }
        return result;
    }

    public static ResultSet doQuery(DbConfig dbConfig, String sql) throws Exception {
        return JdbcCtrl.doQuery(JdbcCtrl.getConnection(dbConfig), sql);
    }

    public static ResultSet doQuery(Connection conn, String sql) throws Exception {
        ResultSet rs;
        try {
            Statement stmt = conn.createStatement();
            stmt.execute(sql);
            rs = stmt.getResultSet();
        }
        catch (SQLException e) {
            String newMsg = "Sql: " + sql + "\n" + e.getMessage();
            throw new SQLException(newMsg, e.getSQLState(), e.getErrorCode());
        }
        return rs;
    }

    private static void setUrl(String url) {
        url_ = url;
    }

    private static void setDriverClassName(String driverClassName) throws SQLException {
        driverClassName_ = driverClassName;
        JdbcCtrl.loadDriver();
    }

    private static void loadDriver() throws SQLException {
        try {
            Class.forName(driverClassName_);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(FileHelper.getResource("err.jdbc.driver.failed.load") + ": " + driverClassName_);
        }
    }

    public static void close(ResultSet rs) {
        try {
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void close(Statement stmt) {
        try {
            stmt.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void close(Connection conn) {
        try {
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

