/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.interfaces.implementation;

import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.xml.abstractions.IXmlable;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class BasicIdentifiable
implements Identifiable,
IXmlable {
    private String name_;
    private String property_;
    public static final String NAME_XML = "Name";
    public static final String PROPERTY_XML = "Property";

    public BasicIdentifiable(String name, String property) {
        this.name_ = name;
        this.property_ = property;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicIdentifiable)) {
            return false;
        }
        BasicIdentifiable other = (BasicIdentifiable)o;
        if (!other.getName().equals(this.getName())) {
            return false;
        }
        return other.getProperty().equals(this.getProperty());
    }

    public String getProperty() {
        return this.property_;
    }

    public static String getClassName() {
        return "BasicIdentifiable";
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element element = doc.createElement(BasicIdentifiable.getClassName());
        element.setAttribute(NAME_XML, this.name_);
        element.setAttribute(PROPERTY_XML, this.property_);
        return element;
    }

    @Override
    public String getMapName() {
        return BasicIdentifiable.getClassName();
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public void setName(String newName) {
        this.name_ = newName;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    public static void addIdfMapXml(Map map, Document doc, Element parent) {
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            try {
                IXmlable xmlable = (IXmlable)it.next();
                Element elmImported = (Element)doc.importNode(xmlable.asXmlElement(), true);
                parent.appendChild(elmImported);
            }
            catch (Exception e) {
                String msg = "BasicIdf.addIdfMapXml.error: " + e.getMessage();
                LogUtil.logErr(msg);
            }
        }
    }

    public static void addIdfMapXmlGrouped(Map map, Document doc, Element parent, String groupName) {
        try {
            Element elmGroup = doc.createElement(groupName);
            BasicIdentifiable.addIdfMapXml(map, doc, elmGroup);
            parent.appendChild(elmGroup);
        }
        catch (Exception e) {
            String msg = "BasicIdf.addIdfMapXmlGrouped.error: " + e.getMessage();
            LogUtil.logMsg(msg);
        }
    }
}

