/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.help;

import com.harrand.coreclasses.element.IId;
import com.harrand.coreclasses.element.Range;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.IDotNotable;
import com.harrand.coreclasses.interfaces.INamed;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.text.QuickTimeFormat;
import com.harrand.util.FileHelper;
import com.harrand.util.LogUtil;
import com.harrand.util.MathUtil;
import com.harrand.util.ResMgr;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class StrHelper {
    public static Format defaultDateFormatter_ = new SimpleDateFormat("ddMMMyyyy");
    public static Format defaultDateTimeFormatter_ = new SimpleDateFormat("dd MMM yyyy - hh:mm:ss a");
    private static final String START_BRACKET = "(";
    private static final String END_BRACKET = ")";
    public static String YES_STR = "Yes";
    public static String NO_STR = "No";
    public static String NULL_STR = "null";
    public static String NULL_STR_UC = "NULL";
    public static String EXEC_STR = "EXEC";
    public static String INVALID_SEL_STR = "Invalid Selection";
    public static String SYNCING_STR = "Synchronizing...";
    public static String REFRESHING_DATA_STR = "Refreshing data...";
    public static String INSERTING_DATA_STR = "Inserting data...";
    public static String UPDATING_DATA_STR = "Updating data...";
    public static String DELETING_DATA_STR = "Deleting data...";
    public static String PROCESSING_STR = ResMgr.getRes("processing");
    public static String READY_STR = ResMgr.getRes("ready");
    public static String UNSPECIFIED_STR = ResMgr.getRes("unspecified.label");

    public static List<String> cloneStringList(List<String> stringList) {
        ArrayList<String> outList = new ArrayList<String>();
        for (String text : stringList) {
            outList.add(new String(text));
        }
        return outList;
    }

    public static String checkComma(String currentString) {
        if (currentString.length() > 0) {
            return ", ";
        }
        return "";
    }

    public static String getDotNote(String nameA, String nameB) {
        return nameA + "." + nameB;
    }

    public static String getDotNoteAsUnderScore(String dotNote) {
        return dotNote.replace('.', '_');
    }

    public static String[] splitDotNote(String dotNote) {
        return dotNote.split("\\.");
    }

    public static String getDisplayWithCount(String displayNm, Collection subItems) {
        int itemCount = subItems.size();
        String str = displayNm + " (" + itemCount + END_BRACKET;
        return str;
    }

    public static String getCsvList(List stringList) {
        StringBuffer sb = new StringBuffer();
        Iterator it = stringList.iterator();
        while (it.hasNext()) {
            sb.append(StrHelper.checkComma(sb.toString()));
            sb.append(it.next().toString());
        }
        return sb.toString().trim();
    }

    public static String getCsvSet(Set set) {
        ArrayList list = new ArrayList(set);
        String str = StrHelper.getCsvList(list);
        return str;
    }

    public static String getRgbCsv(Color color) {
        return START_BRACKET + Integer.toString(color.getRed()) + ", " + Integer.toString(color.getGreen()) + ", " + Integer.toString(color.getBlue()) + END_BRACKET;
    }

    public static String getGradientIdString(Color colorA, Color colorB) {
        return StrHelper.iToStr(colorA.getRed()) + "_" + StrHelper.iToStr(colorA.getGreen()) + "_" + StrHelper.iToStr(colorA.getBlue()) + "_" + StrHelper.iToStr(colorB.getRed()) + "_" + StrHelper.iToStr(colorB.getGreen()) + "_" + StrHelper.iToStr(colorB.getBlue());
    }

    public static String getRectAsStr(Rectangle rect) {
        return "Rect: (" + rect.x + ", " + rect.y + ") to (" + (int)rect.getMaxX() + ", " + (int)rect.getMaxY() + END_BRACKET;
    }

    public static String getRect2DAsStr(Rectangle2D rect) {
        return "Rect: (" + rect.getX() + ", " + rect.getY() + ") to (" + rect.getMaxX() + ", " + rect.getMaxY() + END_BRACKET + " w: " + rect.getWidth() + ", h: " + rect.getHeight();
    }

    public static String getRectAsStr(RoundRectangle2D rect) {
        return "Rect: (" + rect.getX() + ", " + rect.getY() + ") to (" + rect.getMaxX() + ", " + rect.getMaxY() + END_BRACKET + " w: " + rect.getWidth() + ", h: " + rect.getHeight();
    }

    public static String iToStr(int i) {
        return Integer.toString(i);
    }

    public static String getLineFeedList(List stringList, boolean indent) {
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        Iterator it = stringList.iterator();
        while (it.hasNext()) {
            if (!isFirst) {
                sb.append("\n");
            }
            if (indent) {
                sb.append("\t");
            }
            sb.append(it.next().toString());
            isFirst = false;
        }
        return sb.toString();
    }

    public static List getLowerCase(Collection strs) {
        ArrayList<String> lcList = new ArrayList<String>();
        for (String str : strs) {
            lcList.add(str.toLowerCase());
        }
        return lcList;
    }

    public static String getCsvNamed(List namedList) {
        StringBuffer sb = new StringBuffer();
        for (Object obj : namedList) {
            if (obj instanceof INamed) {
                INamed named = (INamed)obj;
                sb.append(StrHelper.checkComma(sb.toString()));
                sb.append(named.getName());
                continue;
            }
            LogUtil.logErr("StrHelper.getCsvName.error: " + obj.toString() + " is not instance of INamed!");
        }
        return sb.toString().trim();
    }

    public static List getNamedNms(List namedList) {
        ArrayList<String> namedNms = new ArrayList<String>();
        for (Object obj : namedList) {
            if (!(obj instanceof INamed)) continue;
            INamed named = (INamed)obj;
            namedNms.add(named.getName());
        }
        return namedNms;
    }

    public static String getLineToStr(Line2D line) {
        return "Line: (" + line.getX1() + ", " + line.getY1() + ") to (" + line.getX2() + ", " + line.getY2() + END_BRACKET;
    }

    public static String mapToString(Map map, String mapName) {
        StringBuffer sb = new StringBuffer("***** InnerMap: " + mapName + " *******" + "\n");
        for (String key : map.keySet()) {
            Object obj = map.get(key);
            String objStr = obj != null ? obj.toString() : "null";
            sb.append(key + "\t\t\t" + objStr + "\n");
        }
        sb.append("***** InnerMap: " + mapName + " - END *******" + "\n");
        return sb.toString();
    }

    public static void printMemoryInfo() {
        Runtime rt = Runtime.getRuntime();
        System.out.println("MemoryFree: " + StrHelper.getMegaBytesFormatted(rt.freeMemory()) + ", Total: " + StrHelper.getMegaBytesFormatted(rt.totalMemory()) + ", Max: " + StrHelper.getMegaBytesFormatted(rt.maxMemory()) + ", Used: " + StrHelper.getMegaBytesFormatted(rt.totalMemory() - rt.freeMemory()));
    }

    public static String getGenericCfgMsg(String verbStr) {
        String msg = "Can not " + verbStr + " using a generic connection. \n" + "Please specify or create a connection to a database server. \n" + "Use 'Add Connection' from the 'Tools' menu.";
        return msg;
    }

    public static String getMegaBytesFormatted(long bytes) {
        double mbytes = MathUtil.getMegaBytes(bytes);
        return NumberFormat.getNumberInstance().format(mbytes);
    }

    public static boolean getPsqlBoolean(String boolStr) {
        String lc = boolStr.toLowerCase();
        return lc.equals("t") || lc.equals("true");
    }

    public static List checkLowerCaseSet(boolean supportsMixedCase, Set names) {
        return StrHelper.checkLowerCase(supportsMixedCase, names);
    }

    public static List checkLowerCase(boolean supportsMixedCase, Collection names) {
        if (supportsMixedCase) {
            return new ArrayList(names);
        }
        ArrayList<String> lcList = new ArrayList<String>();
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String lcStr = ((String)it.next()).toLowerCase();
            lcList.add(lcStr);
        }
        return lcList;
    }

    public static boolean isSame(String stringA, String stringB) {
        return stringA.compareToIgnoreCase(stringB) == 0;
    }

    public static boolean isSame(String strA, String strB, boolean caseSensitive) {
        if (caseSensitive) {
            return strA.equals(strB);
        }
        return strA.equalsIgnoreCase(strB);
    }

    public static ArrayList getStringStarts(String fullString, String findString) {
        ArrayList<Integer> starts = new ArrayList<Integer>();
        int position = 0;
        boolean endOfString = false;
        while (!endOfString) {
            if ((position = fullString.indexOf(findString, position + 1)) >= 0) {
                starts.add(new Integer(position));
                continue;
            }
            endOfString = true;
        }
        return starts;
    }

    public static List splitIntoTextLines(String multilineText) {
        StringBuffer sb = new StringBuffer(multilineText);
        int length = multilineText.length();
        if (length > 0) {
            String cleaned = sb.toString();
            return new ArrayList<String>(Arrays.asList(cleaned.split("\n")));
        }
        return new ArrayList();
    }

    public static String getSubstringSafe(String fullText, int start, int end) {
        if (start < 0 || end > fullText.length()) {
            return "";
        }
        return fullText.substring(start, end);
    }

    public static void addLineFeedIfNeeded(StringBuilder detailSb) {
        if (detailSb.length() > 0) {
            detailSb.append("\n");
        }
    }

    public static String getFileSafeStr(String str) {
        String noPunc = StrHelper.removePunctuation(str);
        String noSpaces = noPunc.replaceAll(" ", "_");
        noSpaces = noSpaces.replaceAll("@", "_");
        noSpaces = noSpaces.replaceAll("\n", "_");
        noSpaces = noSpaces.replaceAll("\t", "_");
        noSpaces = noSpaces.replaceAll("\r", "_");
        noSpaces = noSpaces.replaceAll(";", "_");
        noSpaces = noSpaces.replaceAll(":", "_");
        noSpaces = noSpaces.replaceAll("=", "_");
        noSpaces = noSpaces.replaceAll("\\(", "_");
        noSpaces = noSpaces.replaceAll("\\)", "_");
        noSpaces = noSpaces.replaceAll("'", "_");
        noSpaces = noSpaces.replaceAll("____", "_");
        noSpaces = noSpaces.replaceAll("___", "_");
        noSpaces = noSpaces.replaceAll("__", "_");
        return noSpaces;
    }

    public static String removeFormatting(String text) {
        String newStr = text.replaceAll("\n", "");
        newStr = newStr.replaceAll("\t", "");
        newStr = newStr.replaceAll("\r", "");
        newStr = StrHelper.removeExtraSpaces(newStr);
        return newStr;
    }

    public static String replaceFormattingWithSpaces(String text) {
        String newStr = text.replaceAll("\n", " ");
        newStr = newStr.replaceAll("\t", " ");
        newStr = newStr.replaceAll("\r", " ");
        newStr = StrHelper.removeExtraSpaces(newStr);
        return newStr;
    }

    public static String removeExtraSpaces(String text) {
        String newStr = text.replaceAll("        ", " ");
        newStr = newStr.replaceAll("       ", " ");
        newStr = newStr.replaceAll("      ", " ");
        newStr = newStr.replaceAll("     ", " ");
        newStr = newStr.replaceAll("    ", " ");
        newStr = newStr.replaceAll("   ", " ");
        newStr = newStr.replaceAll("  ", " ");
        return newStr;
    }

    public static String removePunctuation(String text) {
        String newText = text;
        newText = text.replaceAll("\\? ", "  ");
        newText = newText.replaceAll(", ", "  ");
        newText = newText.replaceAll("\\. ", "  ");
        newText = newText.replaceAll("! ", "  ");
        newText = newText.replaceAll("\\?\n", "  ");
        newText = newText.replaceAll(",\n", "  ");
        newText = newText.replaceAll("\\.\n", "  ");
        newText = newText.replaceAll("!\n", "  ");
        newText = newText.replaceAll("\n", " ");
        newText = newText.replaceAll("\t", " ");
        newText = newText.replaceAll(";", " ");
        newText = newText.replaceAll(":", " ");
        newText = newText.replaceAll("=", " ");
        newText = newText.replaceAll("\\(", " ");
        newText = newText.replaceAll("\\)", " ");
        return newText;
    }

    public static String cleanParameterizedInput(String inputStr) {
        String lc = inputStr;
        String cleanedA = lc.replaceAll(";", "");
        String cleanedB = cleanedA.replaceAll(",", " ");
        String cleanedC = cleanedB.replaceAll("   ", " ");
        String cleanedD = cleanedC.replaceAll("  ", " ");
        String trimmed = cleanedD.trim();
        return trimmed;
    }

    public static String removeSpaces(String str) {
        String newStr = new String(str);
        newStr = newStr.replaceAll(" ", "");
        return newStr;
    }

    public static String removeComments(String code) {
        String newCode = StrHelper.removeMultilineComments(code);
        newCode = newCode.replaceAll("<cmm>\n", "");
        newCode = newCode.replaceAll("(?m)^--.*\n", "");
        newCode = newCode.replaceAll("(?m)^##.*\n", "");
        newCode = newCode.replaceAll("(?m)^//.*\n", "");
        newCode = newCode.replaceAll("--.*", "");
        newCode = newCode.replaceAll("##.*", "");
        newCode = newCode.replaceAll("//.*", "");
        newCode = newCode.replaceAll(" \n", "\n");
        return newCode;
    }

    public static String removeMultilineComments(String text) {
        String newText = new String(text);
        StringBuffer sbClean = new StringBuffer();
        int textLn = newText.length();
        boolean inCmm = false;
        for (int i = 0; i < textLn; ++i) {
            String nextThree;
            String nextTwo = i + 2 < textLn ? newText.substring(i, i + 2) : "";
            String string = nextThree = i + 2 < textLn ? newText.substring(i, i + 3) : "";
            if (nextTwo.equals("/*")) {
                inCmm = true;
                ++i;
                continue;
            }
            if (nextThree.equals("*/\n")) {
                inCmm = false;
                i += 2;
                continue;
            }
            if (nextTwo.equals("*/")) {
                inCmm = false;
                ++i;
                continue;
            }
            if (inCmm) continue;
            sbClean.append(newText.substring(i, i + 1));
        }
        return sbClean.toString();
    }

    public static int getCursorWordStart(String source, int cursorPos) {
        int length = source.length();
        int index = 0;
        if (cursorPos >= 0 && cursorPos <= length) {
            if (cursorPos > 0) {
                index = cursorPos - 1;
                String chStr = source.substring(index, index + 1);
                while (index > 0 && !StrHelper.isWordDelimiter(chStr)) {
                    chStr = source.substring(--index, index + 1);
                }
                if (index > 0) {
                    ++index;
                }
            }
        } else {
            StrHelper.throwProgExcept(cursorPos + " is outside the range of 0 and " + "the string length of " + length);
        }
        return index;
    }

    public static String getWordAtPos(String source, int pos) {
        int index;
        StringBuffer wordBuffer = new StringBuffer();
        StringBuffer sourceBuffer = new StringBuffer(source);
        int length = source.length();
        String chStr = "";
        for (index = pos - 1; index >= 0 && index < length && !StrHelper.isWordDelimiter(chStr); --index) {
            chStr = sourceBuffer.substring(index, index + 1);
            if (StrHelper.isWordDelimiter(chStr)) continue;
            wordBuffer.append(chStr);
        }
        wordBuffer.reverse();
        chStr = "";
        for (index = pos; index >= 0 && index < length && !StrHelper.isWordDelimiter(chStr); ++index) {
            chStr = sourceBuffer.substring(index, index + 1);
            if (StrHelper.isWordDelimiter(chStr)) continue;
            wordBuffer.append(chStr);
        }
        return wordBuffer.toString();
    }

    public static Range getEolRange(String text, int pos) {
        int start = 0;
        int end = text.length();
        String EOL = "\n";
        int index = 0;
        boolean quit = false;
        while (!quit) {
            if ((index = text.indexOf(EOL, index)) > -1 && index < pos) {
                start = index;
            } else {
                quit = true;
            }
            ++index;
        }
        int endAttempt = text.indexOf(EOL, pos);
        if (endAttempt > -1) {
            end = endAttempt;
        }
        return new Range(start, end);
    }

    public static Range getEolRange(String text, Range range) {
        int start = 0;
        int end = text.length();
        String EOL = "\n";
        int index = 0;
        boolean quit = false;
        while (!quit) {
            if ((index = text.indexOf(EOL, index)) > -1 && index < range.getStart()) {
                start = index;
            } else {
                quit = true;
            }
            ++index;
        }
        int endAttempt = text.indexOf(EOL, range.getEnd());
        if (endAttempt > -1) {
            end = endAttempt;
        }
        return new Range(start, end);
    }

    public static int getClosestPreviousOccurence(String text, String findText, int pos) {
        int start = -1;
        int index = 0;
        boolean quit = false;
        while (!quit) {
            if ((index = text.indexOf(findText, index)) > -1 && index <= pos) {
                start = index;
            } else {
                quit = true;
            }
            ++index;
        }
        return start;
    }

    private static boolean isWordDelimiter(String charStr) {
        return StrHelper.isPunctuationMark(charStr) || StrHelper.isWhiteSpace(charStr);
    }

    private static boolean isPunctuationMark(String charStr) {
        return charStr.equals(".") || charStr.equals("?") || charStr.equals(";") || charStr.equals(":") || charStr.equals("!");
    }

    private static boolean isWhiteSpace(String charStr) {
        return charStr.equals(" ") || charStr.equals("\n") || charStr.equals("\t");
    }

    public static boolean isWholeWord(int findWordStart, int findWordLength, String fullText) {
        boolean startOk = findWordStart > 0 ? !StrHelper.isLetterOrNumber(fullText.charAt(findWordStart - 1)) : true;
        int lastWordCharPosition = findWordStart + findWordLength;
        boolean endOk = lastWordCharPosition < fullText.length() - 1 ? !StrHelper.isLetterOrNumber(fullText.charAt(lastWordCharPosition)) : true;
        return startOk && endOk;
    }

    public static String getUnderline(String[] titles) {
        StringBuffer sb = new StringBuffer(19);
        boolean sum = false;
        for (int i = 0; i < titles.length; ++i) {
            sb.append(titles[i]).append("\t");
        }
        return StrHelper.getDupString("-", sb.length() * 3) + "\n";
    }

    public static String getDupString(String str, int duplicates) {
        StringBuffer sb = new StringBuffer(31);
        for (int i = 0; i < duplicates; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static String getTruncated(String str, int maxLength) {
        return StrHelper.getTruncatedWithEllipsis(str, maxLength, false);
    }

    public static String getTruncatedWithEllipsis(String str, int maxLength, boolean addElipsis) {
        boolean isOverLength;
        boolean bl = isOverLength = str.length() > maxLength;
        if (isOverLength) {
            String text = str.substring(0, maxLength);
            if (addElipsis) {
                text = text + "...";
            }
            return text;
        }
        return str;
    }

    public static String getAddOrEditText(Object obj) {
        String str = obj == null ? FileHelper.getResource("add.label") : FileHelper.getResource("edit.label");
        return str + " ";
    }

    public static boolean isLetterOrNumber(char ch) {
        return 'A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z' || '0' <= ch && ch <= '9';
    }

    public static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isHexStr(String str) {
        String startChars = str.length() > 2 ? str.substring(0, 2) : "";
        return startChars.equalsIgnoreCase("0x");
    }

    public static String replaceWildCard(String wildCardStr, String value) {
        String newStr = new String(wildCardStr);
        newStr = newStr.replaceFirst("\\*", value);
        return newStr;
    }

    public static String replaceWildCards(String wildCardStr, String[] values) {
        String newStr = new String(wildCardStr);
        for (int i = 0; i < values.length; ++i) {
            newStr = newStr.replaceFirst("\\*", values[i]);
        }
        return newStr;
    }

    public static String getBld(Calendar cal) {
        int ye = cal.get(1);
        int da = cal.get(5);
        String yeStr = Integer.toString(ye - 2004 + 3);
        String daStr = Integer.toString(45 - da);
        return yeStr + daStr;
    }

    public static String getPlf(Calendar cal) {
        int mo = cal.get(2);
        return Integer.toString(26 - mo);
    }

    public static Calendar getDateBldPlf(String bld, String plf) {
        GregorianCalendar calendar = null;
        try {
            String yeStr = bld.substring(0, bld.length() - 2);
            String daStr = bld.substring(bld.length() - 2);
            int ye = Integer.parseInt(yeStr) - 3 + 2004;
            int mo = 26 - Integer.parseInt(plf);
            int da = 45 - Integer.parseInt(daStr);
            calendar = new GregorianCalendar(ye, mo, da);
        }
        catch (Exception e) {
            System.out.println("getDateBldPlf");
        }
        return calendar;
    }

    public static Calendar getDateBldPlf_v1_0_0(String bld, String plf) {
        GregorianCalendar calendar = null;
        try {
            String yeStr = bld.substring(0, bld.length() - 2);
            String daStr = bld.substring(bld.length() - 2);
            int ye = Integer.parseInt(yeStr) - 3 + 2004;
            int mo = 13 - Integer.parseInt(plf);
            int da = 45 - Integer.parseInt(daStr);
            calendar = new GregorianCalendar(ye, mo, da);
        }
        catch (Exception e) {
            System.out.println("getDateBldPlf");
        }
        return calendar;
    }

    public static String processHtml(String text) {
        String newText = text.replaceAll("\"", "&quot;");
        return newText;
    }

    public static int getLastClosingBracketPos(String text) {
        int closePos = -1;
        int length = text.length();
        if (length > 0) {
            int currPos = length - 1;
            boolean found = false;
            while (currPos >= 0 && !found) {
                String currCh = text.substring(currPos, currPos + 1);
                if (currCh.equals(END_BRACKET)) {
                    closePos = currPos;
                    found = true;
                    continue;
                }
                --currPos;
            }
        }
        return closePos;
    }

    public static int getClosingBracketPos(String text, int startPos) {
        int openPos = text.indexOf(START_BRACKET, startPos);
        int currentPos = openPos + 1;
        int openCount = 1;
        boolean found = false;
        while (currentPos >= 0 && currentPos < text.length() && !found) {
            int nextOpen = text.indexOf(START_BRACKET, currentPos);
            int nextClose = text.indexOf(END_BRACKET, currentPos);
            if (nextOpen > -1 && nextOpen < nextClose) {
                ++openCount;
                currentPos = nextOpen;
            } else {
                --openCount;
                currentPos = nextClose;
            }
            if (openCount == 0) {
                found = true;
                continue;
            }
            ++currentPos;
        }
        return currentPos;
    }

    public static String removePsqlViewBracket(String rawSrc) {
        String outStr = new String(rawSrc);
        outStr = outStr.replaceAll("\\(\\(\\(\\(\\(", "");
        outStr = outStr.replaceAll("\\(\\(\\(\\(", "");
        outStr = outStr.replaceAll("\\(\\(\\(", "");
        outStr = outStr.replaceAll("\\(\\(", "");
        outStr = outStr.replaceAll("\\)\\)\\)\\)\\)", "");
        outStr = outStr.replaceAll("\\)\\)\\)\\)", "");
        outStr = outStr.replaceAll("\\)\\)\\)", "");
        outStr = outStr.replaceAll("\\)\\)", "");
        return outStr;
    }

    public static boolean containsUpperCase(String str) {
        String compareStr = str.toLowerCase();
        return !compareStr.equals(str);
    }

    public static String escapeQuotes(String str) {
        String outStr = str.replaceAll("'", "\\\\'");
        return outStr;
    }

    public static String escapeWithQuotePair(String str) {
        String outStr = str.replaceAll("'", "''");
        return outStr;
    }

    public static String encloseSingleQuotes(String str) {
        return "'" + str + "'";
    }

    public static String encloseDblQuotes(String str) {
        return "\"" + str + "\"";
    }

    public static String encloseDblQuotesDotNote(String str) {
        String[] parts = str.split("\\.");
        String enquoted = StrHelper.encloseDblQuotes(parts[0]) + "." + StrHelper.encloseDblQuotes(parts[1]);
        return enquoted;
    }

    public static String getDblEnquotedNm(String nm) {
        return StrHelper.encloseDblQuotes(nm);
    }

    public static String removeDblQuotes(String str) {
        return str.replaceAll("\"", "");
    }

    public static String removeDblQuoteDup(String str) {
        return str.replaceAll("\"\"", "\"");
    }

    public static String removeEnclosingQuotes(String str) {
        int len = str.length();
        if (len > 2) {
            if (str.substring(len - 1).equals("'")) {
                str = str.substring(0, len - 1);
            }
            if (str.substring(0, 1).equals("'")) {
                str = str.substring(1);
            }
        }
        return str;
    }

    public static String removeEnclosingChars(String strIn, String startChar, String endChar) {
        int len = strIn.length();
        if (len >= 2) {
            String strOut = strIn;
            if (strOut.substring(len - 1).equals(endChar)) {
                strOut = strOut.substring(0, len - 1);
            }
            if (strOut.substring(0, 1).equals(startChar)) {
                strOut = strOut.substring(1);
            }
            return strOut;
        }
        return strIn;
    }

    public static String removeTrailingChar(String strIn, String charToRemove) {
        int len = strIn.length();
        String strOut = strIn;
        if (len >= 1 && strOut.substring(len - 1).equals(charToRemove)) {
            strOut = strOut.substring(0, len - 1);
        }
        return strOut;
    }

    public static String getDblEnquotedBracketNm(String nm) {
        StringBuffer sb = new StringBuffer(nm);
        int brackIdx = sb.indexOf(START_BRACKET);
        if (brackIdx > 0) {
            sb.insert(brackIdx, "\"");
        } else {
            sb.append("\"");
        }
        int dotIdx = sb.indexOf(".");
        if (dotIdx > 0) {
            sb.insert(dotIdx + 1, "\"");
        }
        if (dotIdx > 0) {
            sb.insert(dotIdx, "\"");
        }
        sb.insert(0, "\"");
        return sb.toString();
    }

    public static boolean strContains(String bigStr, String littleStr) {
        return bigStr.indexOf(littleStr) >= 0;
    }

    public static String getSectionStringNoTermination(String msg) {
        return "/******************** " + msg + " ************************";
    }

    public static String getSectionString(String msg) {
        return "/******************** " + msg + " ************************/";
    }

    public static String getSectionStringShort(String msg) {
        return "/************ " + msg + " ***************/";
    }

    public static String getEnclosedInSingleDash(String str) {
        String newStr = "-----------------------------------------------------------\n" + str + "\n" + "-----------------------------------------------------------\n";
        return newStr;
    }

    public static String getEnclosedInDoubleDash(String str) {
        String newStr = "===========================================================\n" + str + "\n" + "===========================================================\n";
        return newStr;
    }

    public static Integer extractLength(String dataTypeStr) {
        Integer lengthObj = null;
        String lengthStr = null;
        String numberPart = StrHelper.extractBetweenBrackets(dataTypeStr);
        if (numberPart == null) {
            return null;
        }
        lengthStr = numberPart.indexOf(",") > 0 ? numberPart.split(",")[0] : numberPart;
        if (StrHelper.isNumeric(lengthStr)) {
            lengthObj = new Integer(lengthStr);
        } else {
            LogUtil.logErr("StrHelper.extractLength: Could not extract length from >" + dataTypeStr + "<");
        }
        return lengthObj;
    }

    public static Integer extractScale(String dataTypeStr) {
        Integer scaleObj = null;
        String scaleStr = null;
        String numberPart = StrHelper.extractBetweenBrackets(dataTypeStr);
        if (numberPart == null) {
            return null;
        }
        if (numberPart.indexOf(",") > 0) {
            scaleStr = numberPart.split(",")[1];
            scaleObj = new Integer(scaleStr);
        } else {
            LogUtil.logErr("StrHelper.extractScale: Could not extract scale from >" + dataTypeStr + "<");
        }
        return scaleObj;
    }

    private static String extractBetweenBrackets(String fullStr) {
        int startPos = fullStr.indexOf(START_BRACKET);
        if (startPos == -1) {
            return null;
        }
        int endPos = fullStr.indexOf(END_BRACKET);
        if (endPos == -1) {
            return null;
        }
        String between = fullStr.substring(startPos + 1, endPos);
        return between;
    }

    public static String getCalendarAsMMMDDYYYY(Calendar cal) {
        return String.format("%tB %te, %tY%n", cal, cal, cal);
    }

    public static String formatDate(Date date) {
        return defaultDateFormatter_.format(date);
    }

    public static Date parseDate(String dateStr) {
        Date date = null;
        if (dateStr == null || dateStr.length() == 0) {
            return date;
        }
        date = StrHelper.parseDateDisp(dateStr, DateFormat.getDateInstance(2));
        if (date == null) {
            date = StrHelper.parseDateDisp(dateStr, DateFormat.getDateInstance(3));
        }
        if (date == null) {
            date = StrHelper.parseDateDisp(dateStr, DateFormat.getDateInstance(2));
        }
        if (date == null) {
            date = StrHelper.parseDateDisp(dateStr, DateFormat.getDateInstance(1));
        }
        if (date == null) {
            date = StrHelper.parseDateDisp(dateStr, DateFormat.getDateInstance(0));
        }
        if (date == null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            date = StrHelper.parseDateDisp(dateStr, format);
        }
        return date;
    }

    public static Date parseDateTime(String dateStr) {
        SimpleDateFormat format;
        Date date = null;
        if (dateStr == null || dateStr.length() == 0) {
            return date;
        }
        date = StrHelper.parseDateDisp(dateStr, DateFormat.getDateTimeInstance());
        if (date == null) {
            date = StrHelper.parseDateDisp(dateStr, DateFormat.getTimeInstance());
        }
        if (date == null) {
            format = new SimpleDateFormat("HH:mm:ss");
            date = StrHelper.parseDateDisp(dateStr, format);
        }
        if (date == null) {
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            date = StrHelper.parseDateDisp(dateStr, format);
        }
        if (date == null) {
            format = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss");
            date = StrHelper.parseDateDisp(dateStr, format);
        }
        if (date == null) {
            // empty if block
        }
        return date;
    }

    private static Date parseDateDisp(String dateStr, DateFormat format) {
        Date date;
        format.setLenient(false);
        try {
            date = format.parse(dateStr);
        }
        catch (Exception e) {
            date = null;
        }
        return date;
    }

    public static String removeCurrencyChars(String moneyStr) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < moneyStr.length(); ++i) {
            String chStr = moneyStr.substring(i, i + 1);
            if (!StrHelper.isNumeric(chStr) && !chStr.equals(",") && !chStr.equals(".") && !chStr.equals("-")) continue;
            sb.append(chStr);
        }
        return sb.toString();
    }

    public static void throwProgrammingException(String msg) {
        try {
            throw new Exception("Programmer Thrown Exception: " + msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static void throwProgExcept(String msg) {
        StrHelper.throwProgrammingException(msg);
    }

    public static String getStackTraceAsStr(String msg) {
        String str = "strheper.stack.trace.empty";
        try {
            throw new Exception(msg);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            str = sw.toString();
            return str;
        }
    }

    public static boolean isZeroValue(String str) {
        if (str == null) {
            return false;
        }
        boolean onlyZeros = true;
        int length = str.length();
        for (int i = 0; onlyZeros && i < length; ++i) {
            char ch = str.charAt(i);
            if (ch == '0' || ch == '.' || ch == '-' || ch == ':' || ch == ' ') continue;
            onlyZeros = false;
        }
        return onlyZeros;
    }

    public static String replacAllIgnoreCase(String operand, String searchText, String replaceText) {
        String regex = "(?i)" + searchText;
        String returnText = operand.replaceAll(regex, replaceText);
        return returnText;
    }

    public static String replaceAll(String fullString, String findString, String replaceString) {
        int length = findString.length();
        ArrayList starts = StrHelper.getStringStarts(fullString, findString);
        StringBuffer buffer = new StringBuffer(fullString);
        Iterator it = starts.iterator();
        while (it.hasNext()) {
            int position = (Integer)it.next();
            buffer.replace(position, position + length, replaceString);
        }
        return buffer.toString();
    }

    public static boolean identifiablesEqual(Collector collA, Collector collB, String mapName) {
        if (!collB.getKeys(mapName).equals(collA.getKeys(mapName))) {
            return false;
        }
        for (String itemName : collA.getKeys(mapName)) {
            Identifiable objB;
            Identifiable objA = collB.get(mapName, itemName);
            if (objA.equals(objB = collA.get(mapName, itemName))) continue;
            return false;
        }
        return true;
    }

    public static boolean getMatchesAsteriskable(String asteriskableNm, String findNm) {
        boolean simpleMatch = asteriskableNm.equals(findNm);
        boolean asteriskMatchA = asteriskableNm.equals(findNm + "*");
        boolean asteriskMatchB = asteriskableNm.equals(findNm + " *");
        boolean isMatch = simpleMatch || asteriskMatchA || asteriskMatchB;
        return isMatch;
    }

    public static String getMatrixAsString(Object[][] data) {
        StringBuffer sb = new StringBuffer(300);
        if (data.length > 0) {
            int colCount = data[0].length;
            int rowCount = data.length;
            for (int row = 0; row < rowCount; ++row) {
                for (int col = 0; col < colCount; ++col) {
                    Object obj = data[row][col];
                    if (obj == null) {
                        obj = "NULL";
                    }
                    sb.append(obj.toString());
                    sb.append("\t");
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static final String replaceNodeNmPart(String dotNote, String newNm) {
        String delim = "/";
        StringBuffer sb = new StringBuffer();
        String[] parts = dotNote.split("/");
        for (int i = 0; i < parts.length - 1; ++i) {
            if (sb.length() > 0) {
                sb.append(delim);
            }
            sb.append(parts[i]);
        }
        if (sb.length() > 0) {
            sb.append(delim);
        }
        sb.append(newNm);
        return sb.toString();
    }

    public static String getNullSafeDotNote(String[] strs) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strs.length; ++i) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(strs[i]);
        }
        return sb.toString();
    }

    public static String getNullSafeDotNote(IDotNotable dotNotable) {
        if (dotNotable != null) {
            return dotNotable.getDotNote();
        }
        return "";
    }

    public static String getNullSafeString(Object nullableObj) {
        if (nullableObj == null) {
            return "";
        }
        if (nullableObj instanceof String) {
            return nullableObj.toString();
        }
        if (nullableObj instanceof IId) {
            int i = ((IId)nullableObj).getId();
            return Integer.toString(i);
        }
        if (nullableObj instanceof Double) {
            return ((Double)nullableObj).toString();
        }
        if (nullableObj instanceof Integer) {
            return ((Integer)nullableObj).toString();
        }
        StrHelper.throwProgExcept("Unsupported nullableObj Class: " + nullableObj.getClass().getName());
        return "";
    }

    public static String getNullSafeName(Identifiable idf) {
        String safe = NULL_STR_UC;
        if (idf != null) {
            safe = idf.getName();
        }
        return safe;
    }

    public static Integer getNullSafeInt(String str) {
        if (str == null) {
            return null;
        }
        return Integer.parseInt(str);
    }

    public static String getObservableTrace(Object previousObject, String currentObjectName) {
        String arg = previousObject != null ? previousObject.toString() + FileHelper.getResourceStringCommon("observable.relay") : FileHelper.getResourceStringCommon("observable.source");
        return arg + currentObjectName;
    }

    public static String getElapseTimeText(long milliSec) {
        String str = FileHelper.getRes("label.time.elapsed");
        if (milliSec >= 0L) {
            str = str + " " + QuickTimeFormat.msToSecs(milliSec);
        }
        return str;
    }

    public static String getElapsedTime(long startMillis, String msg) {
        long currentTime = System.currentTimeMillis();
        return msg + " Time: " + QuickTimeFormat.msToSecs(currentTime - startMillis);
    }

    public static String getObservableRelayString(Identifiable id) {
        return FileHelper.getResourceStringCommon("observable.relay") + id.getName();
    }
}

