/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.file;

import com.harrand.coreclasses.file.FilePath;
import com.harrand.coreclasses.file.IFilePathSvr;
import com.harrand.coreclasses.file.IFileUseMgr;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.INamed;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.xml.abstractions.IXmlable;
import com.harrand.util.XmlHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class BasicFileUseMgr
implements IFileUseMgr,
IXmlable,
IObservable {
    private IFilePathSvr filePathSvr_;
    private Map recentFilesMap_ = new TreeMap();
    private Map lastPathMap_ = new TreeMap();
    private BasicObservable observable_ = new BasicObservable();
    public static final int MAX_RECENT_FILES = 4;

    public BasicFileUseMgr(IFilePathSvr filePathSvr) {
        this.filePathSvr_ = filePathSvr;
        this.buildMaps();
    }

    private void buildMaps() {
        this.recentFilesMap_.put("Database", new ArrayList());
        this.recentFilesMap_.put("SqlScript", new ArrayList());
        this.recentFilesMap_.put("JPEG", new ArrayList());
        this.recentFilesMap_.put("PNG", new ArrayList());
        this.recentFilesMap_.put("SVG", new ArrayList());
        this.lastPathMap_.put("Database", null);
        this.lastPathMap_.put("SqlScript", null);
        this.lastPathMap_.put("JPEG", null);
        this.lastPathMap_.put("PNG", null);
        this.lastPathMap_.put("SVG", null);
    }

    public static String clazz() {
        return "BasicFileUseMgr";
    }

    private void setLastPath(String nameId, String path) {
        this.lastPathMap_.put(nameId, path);
    }

    private String getLastPath(String nameId) {
        return (String)this.lastPathMap_.get(nameId);
    }

    private List truncateList(List list, int maxCount) {
        if (list.size() > 0 && list.size() > maxCount) {
            return new ArrayList(list.subList(0, maxCount));
        }
        return list;
    }

    private String getPrefNameId(String nameId) {
        String prefNameId = "";
        if (nameId.equals("Database")) {
            prefNameId = "filePath.desc.db";
        } else if (nameId.equals("SqlScript")) {
            prefNameId = "filePath.desc.script";
        } else if (nameId.equals("JPEG")) {
            prefNameId = "filePath.desc.jpeg";
        } else if (nameId.equals("PNG")) {
            prefNameId = "filePath.desc.png";
        } else if (nameId.equals("SVG")) {
            prefNameId = "filePath.desc.png";
        } else {
            this.throwUnsupportedNameId(nameId);
        }
        return prefNameId;
    }

    private void throwUnsupportedNameId(String nameId) {
        StrHelper.throwProgExcept("Unsupported nameId: " + nameId);
    }

    @Override
    public void addRecentFile(String nameId, File file, boolean saveFlag) {
        File fileDup = new File(file.getPath());
        List filesList = (List)this.recentFilesMap_.get(nameId);
        ArrayList<File> removeList = new ArrayList<File>();
        removeList.add(fileDup);
        filesList.removeAll(removeList);
        filesList.add(0, fileDup);
        this.truncateList(filesList, 4);
        this.setLastPath(nameId, fileDup.getPath());
        if (saveFlag) {
            this.filePathSvr_.save();
        }
        this.notifyObservers(new UpdateChain(fileDup));
    }

    @Override
    public File getDefaultFile(String nameId, INamed named) {
        FilePath filePath;
        File defaultFile = null;
        String defaultPath = this.getLastPath(nameId);
        if (defaultPath == null && (filePath = this.filePathSvr_.getFilePath(this.getPrefNameId(nameId))) != null) {
            defaultPath = filePath.getPath();
        }
        if (defaultPath == null) {
            defaultPath = "";
        }
        defaultFile = named != null ? new File(defaultPath + File.separator + named.getName() + "." + this.getFileExtension(nameId)) : new File(defaultPath);
        return defaultFile;
    }

    @Override
    public String getFileExtension(String nameId) {
        String ext = "";
        if (nameId.equals("Database")) {
            ext = "xml";
        } else if (nameId.equals("SqlScript")) {
            ext = "sql";
        } else if (nameId.equals("JPEG")) {
            ext = "jpg";
        } else if (nameId.equals("PNG")) {
            ext = "png";
        } else if (nameId.equals("SVG")) {
            ext = "svg";
        } else {
            this.throwUnsupportedNameId(nameId);
        }
        return ext;
    }

    @Override
    public int getMaxRecentFile() {
        return 4;
    }

    @Override
    public List getRecentFiles(String nameId) {
        List list = (List)this.recentFilesMap_.get(nameId);
        return new ArrayList(list);
    }

    @Override
    public File getMostRecentFile(String nameId) {
        File lastFile = null;
        List recentFiles = this.getRecentFiles(nameId);
        if (!recentFiles.isEmpty()) {
            lastFile = (File)recentFiles.get(0);
        }
        return lastFile;
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element element = doc.createElement(BasicFileUseMgr.clazz());
        Element elmRecentFiles = doc.createElement("RecentFiles");
        for (String nameId : this.recentFilesMap_.keySet()) {
            Element elmNameId = doc.createElement(nameId);
            List files = (List)this.recentFilesMap_.get(nameId);
            for (File file : files) {
                Element elmFile = doc.createElement("File");
                elmFile.setAttribute("Path", file.getPath());
                elmNameId.appendChild(elmFile);
            }
            elmRecentFiles.appendChild(elmNameId);
        }
        element.appendChild(elmRecentFiles);
        return element;
    }

    public static BasicFileUseMgr fromXml(Element element, IFilePathSvr filePathSvr) {
        BasicFileUseMgr mgr = new BasicFileUseMgr(filePathSvr);
        Element elmRecentFiles = XmlHelper.getFirstElementByTagName(element, "RecentFiles");
        BasicFileUseMgr.listFromXml(mgr, "Database", elmRecentFiles);
        BasicFileUseMgr.listFromXml(mgr, "SqlScript", elmRecentFiles);
        BasicFileUseMgr.listFromXml(mgr, "JPEG", elmRecentFiles);
        BasicFileUseMgr.listFromXml(mgr, "PNG", elmRecentFiles);
        BasicFileUseMgr.listFromXml(mgr, "SVG", elmRecentFiles);
        return mgr;
    }

    private static void listFromXml(BasicFileUseMgr mgr, String nameId, Element elmRecentFiles) {
        Element elmNameId = XmlHelper.getFirstElementByTagName(elmRecentFiles, nameId);
        NodeList nodes = elmNameId != null ? elmNameId.getElementsByTagName("File") : new IIOMetadataNode();
        for (int i = nodes.getLength() - 1; i >= 0; --i) {
            String filePath = ((Element)nodes.item(i)).getAttribute("Path");
            File file = new File(filePath);
            mgr.addRecentFile(nameId, file, false);
        }
    }

    @Override
    public String getName() {
        return BasicFileUseMgr.clazz();
    }

    @Override
    public void setName(String newName) {
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }
}

