/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.element;

import com.harrand.util.LogUtil;
import com.harrand.util.MathUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StringPair
implements Comparable {
    private String strA_ = null;
    private String strB_ = null;
    public static final int ID_A = 1;
    public static final int ID_B = 2;

    public StringPair(String strA, String strB) {
        this.strA_ = strA;
        this.strB_ = strB;
        if (this.strA_ == null && this.strB_ == null) {
            LogUtil.logErr("StringPair can not have both values as null.");
        }
    }

    public String getStrA() {
        return this.strA_;
    }

    public String getStrB() {
        return this.strB_;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringPair)) {
            return false;
        }
        StringPair other = (StringPair)o;
        if (!MathUtil.isEquivalent(other.getStrA(), this.getStrA())) {
            return false;
        }
        return MathUtil.isEquivalent(other.getStrB(), this.getStrB());
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (!(obj instanceof StringPair)) {
            return 0;
        }
        StringPair other = (StringPair)obj;
        String otherStr = other.getStrB() != null ? other.getStrB() : other.getStrA();
        String thisStr = this.getStrB() != null ? this.getStrB() : this.getStrA();
        return thisStr.compareTo(otherStr);
    }

    public String toString() {
        String str1 = this.getStrA() != null ? this.getStrA() : "null";
        String str2 = this.getStrB() != null ? this.getStrB() : "null";
        return "(" + str1 + ", " + str2 + ")";
    }

    public static List getItemList(List pairs, int itemId) {
        ArrayList<String> itemList = new ArrayList<String>();
        for (StringPair pair : pairs) {
            String str = itemId == 1 ? pair.getStrA() : pair.getStrB();
            itemList.add(str);
        }
        return itemList;
    }

    public static StringPair getMatch(List pairs, String inStr, int findId) {
        StringPair foundPair = null;
        Iterator it = pairs.iterator();
        while (foundPair == null && it.hasNext()) {
            StringPair pair = (StringPair)it.next();
            String evalStr = findId == 1 ? pair.getStrA() : pair.getStrB();
            if (evalStr == null || !evalStr.equalsIgnoreCase(inStr)) continue;
            foundPair = pair;
        }
        return foundPair;
    }
}

