/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.element;

import com.harrand.coreclasses.element.IId;
import com.harrand.coreclasses.help.StrHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class IdGroup {
    private String name_;
    private String displayName_;
    private String abbr_;
    private Map idsMap_;

    public IdGroup(String name, String abbr, String displayName) {
        this(name, abbr, displayName, new ArrayList());
    }

    public IdGroup(String name, String abbr, String displayName, List ids) {
        this.name_ = name;
        this.abbr_ = abbr;
        this.displayName_ = displayName;
        this.buildIdMap(ids);
    }

    private void buildIdMap(List ids) {
        this.clearIds();
        for (Object obj : ids) {
            if (obj instanceof IId) {
                IId iId = (IId)obj;
                this.idsMap_.put(iId.getName(), iId);
                continue;
            }
            StrHelper.throwProgExcept("Expected IIds only, found: " + obj.getClass().getName());
        }
    }

    public String getDisplayName() {
        return this.displayName_;
    }

    public String getName() {
        return this.name_;
    }

    public String getAbbr() {
        return this.abbr_;
    }

    public void addId(IId id) {
        this.idsMap_.put(id.getName(), id);
    }

    public void clearIds() {
        this.idsMap_ = new HashMap();
    }

    public void removeId(String idName) {
        this.idsMap_.remove(idName);
    }

    public IId getId(String idName) {
        return (IId)this.idsMap_.get(idName);
    }

    public List getIds() {
        return new ArrayList(this.idsMap_.values());
    }

    public int getIdCount() {
        return this.idsMap_.size();
    }
}

