/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.element;

import com.harrand.coreclasses.xml.abstractions.IXmlable;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Cardinality
implements IXmlable {
    private boolean allowOne_;
    private boolean allowZero_;
    private boolean allowMany_;
    public static final int PARENT_ID = 0;
    public static final int CHILD_ID = 1;
    public static final String ALLOW_ZERO_XML = "AllowZero";
    public static final String ALLOW_ONE_XML = "AllowOne";
    public static final String ALLOW_MANY_XML = "AllowMany";

    public Cardinality(boolean allowZero, boolean allowOne, boolean allowMany) {
        this.allowOne_ = allowOne;
        this.allowZero_ = allowZero;
        this.allowMany_ = allowMany;
        this.validateInput();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cardinality)) {
            return false;
        }
        Cardinality other = (Cardinality)o;
        if (other.getAllowZero() != this.getAllowZero()) {
            return false;
        }
        if (other.getAllowOne() != this.getAllowOne()) {
            return false;
        }
        return other.getAllowMany() == this.getAllowMany();
    }

    public boolean getAllowZero() {
        return this.allowZero_;
    }

    public boolean getAllowOne() {
        return this.allowOne_;
    }

    public boolean getAllowMany() {
        return this.allowMany_;
    }

    public boolean isOne() {
        return !this.allowZero_ && this.allowOne_ && !this.allowMany_;
    }

    public boolean isZeroOne() {
        return this.allowZero_ && this.allowOne_ && !this.allowMany_;
    }

    public boolean isZeroMany() {
        return this.allowZero_ && this.allowMany_;
    }

    public boolean isOneMany() {
        return !this.allowZero_ && this.allowOne_ && this.allowMany_;
    }

    public String toString() {
        return this.getDisplayText();
    }

    public String getDisplayText() {
        StringBuffer sb = new StringBuffer();
        if (this.getAllowZero()) {
            this.appendDisplayText(sb, "0");
        }
        if (this.getAllowOne()) {
            this.appendDisplayText(sb, "1");
        }
        if (this.getAllowMany()) {
            this.appendDisplayText(sb, "m");
        }
        return sb.toString();
    }

    public static List getDefaultCardinalityList(int relationId) {
        ArrayList<Cardinality> defaults = new ArrayList<Cardinality>();
        switch (relationId) {
            case 0: {
                defaults.add(new Cardinality(false, true, false));
                defaults.add(new Cardinality(true, true, false));
                break;
            }
            case 1: {
                defaults.add(new Cardinality(true, true, false));
                defaults.add(new Cardinality(true, false, true));
                defaults.add(new Cardinality(false, true, false));
                defaults.add(new Cardinality(false, true, true));
                break;
            }
            default: {
                LogUtil.logErr("Cardinality.getDefaultCardinalityList could not match relationaId: " + relationId);
            }
        }
        return defaults;
    }

    public static String clazz() {
        return "Cardinality";
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element element = doc.createElement(Cardinality.clazz());
        XmlHelper.setAttr(element, ALLOW_ZERO_XML, this.getAllowZero());
        XmlHelper.setAttr(element, ALLOW_ONE_XML, this.getAllowOne());
        XmlHelper.setAttr(element, ALLOW_MANY_XML, this.getAllowMany());
        return element;
    }

    public static Cardinality fromXml(Element element) {
        boolean zero = XmlHelper.getAttrBool(element, ALLOW_ZERO_XML);
        boolean one = XmlHelper.getAttrBool(element, ALLOW_ONE_XML);
        boolean many = XmlHelper.getAttrBool(element, ALLOW_MANY_XML);
        return new Cardinality(zero, one, many);
    }

    @Override
    public String getName() {
        return this.getDisplayText();
    }

    @Override
    public void setName(String newName) {
        LogUtil.logErr("Cardinality.setName() not implemented");
    }

    private void appendDisplayText(StringBuffer sb, String text) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(text);
    }

    private void validateInput() {
        if (!(this.allowOne_ || this.allowZero_ || this.allowMany_)) {
            LogUtil.logErr("Cardinality can not have all flags set to 'false'");
        }
        this.convertPre221();
    }

    private void convertPre221() {
        if (this.allowZero_ && this.allowOne_ && this.allowMany_) {
            this.allowOne_ = false;
        }
        if (!this.allowZero_ && !this.allowOne_ && this.allowMany_) {
            this.allowOne_ = true;
        }
    }
}

