/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.db;

import com.harrand.coreclasses.help.StrHelper;

public final class DbConfig {
    private int dbmsId_;
    private String serverName_;
    private String databaseName_;
    private String userName_;
    private String pwd_;
    public static final String MYSQL = "MySql";
    public static final String POSTGRESQL = "PostgreSql";
    public static final String MS_ACCESS = "MS Access";
    public static final String MS_SQL_SERVER = "MS SQL Server";
    public static final String ORACLE = "Oracle";
    public static final int MYSQL_ID = 0;
    public static final int POSTGRESQL_ID = 1;
    public static final int MS_ACCESS_ID = 2;
    public static final int MS_SQL_SERVER_ID = 3;
    public static final int ORACLE_ID = 4;

    public DbConfig(int dbmsId, String serverName, String databaseName, String userName, String pwd) {
        this.dbmsId_ = dbmsId;
        this.serverName_ = serverName;
        this.databaseName_ = databaseName;
        this.userName_ = userName;
        this.pwd_ = pwd;
    }

    public String getServerName() {
        return this.serverName_;
    }

    public String getDatabaseName() {
        return this.databaseName_;
    }

    public String getUserName() {
        return this.userName_;
    }

    public String getPassword() {
        return this.pwd_;
    }

    public int getDbmsId() {
        return this.dbmsId_;
    }

    public String getConnectionString() {
        String str = "jdbc:";
        switch (this.dbmsId_) {
            case 2: {
                str = str + "error - MS Access not supported";
                break;
            }
            case 3: {
                str = str + "microsoft:sqlserver://" + this.serverName_ + ";databasename=" + this.databaseName_;
                break;
            }
            case 0: {
                str = str + "mysql://" + this.serverName_ + "/" + this.databaseName_;
                break;
            }
            case 1: {
                str = str + "postgresql://" + this.serverName_ + "/" + this.databaseName_;
                break;
            }
            default: {
                StrHelper.throwProgExcept("Unsupported DbmsId:" + this.dbmsId_);
            }
        }
        return str;
    }

    public String getDriverName() {
        String driver = "";
        switch (this.dbmsId_) {
            case 0: {
                driver = "com.mysql.jdbc.Driver";
                break;
            }
            case 3: {
                driver = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
                break;
            }
            case 2: {
                driver = "sun.jdbc.odbc.JdbcOdbcDriver";
                break;
            }
            case 1: {
                driver = "org.postgresql.Driver";
                break;
            }
            default: {
                driver = "error - No default driver available.";
            }
        }
        return driver;
    }

    public String getDbmsName() {
        String name = "";
        switch (this.dbmsId_) {
            case 0: {
                name = MYSQL;
                break;
            }
            case 3: {
                name = MS_SQL_SERVER;
                break;
            }
            case 2: {
                name = MS_ACCESS;
                break;
            }
            case 1: {
                name = POSTGRESQL;
                break;
            }
            default: {
                StrHelper.throwProgExcept("Unsupported DbmsId:" + this.dbmsId_);
            }
        }
        return name;
    }

    public String toString() {
        String str = this.getDbmsName() + ":\\\\" + this.serverName_ + "\\" + this.databaseName_;
        return str;
    }
}

