/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.dataEntry;

import com.harrand.coreclasses.dataEntry.INameBuilder;
import com.harrand.util.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class BasicNameBuilder
implements INameBuilder {
    private boolean useBaseName_;
    private String baseName_;
    private String prefix_;
    private String suffix_;
    public static final String XML_CLASS = "BasicNameBuilder";
    private static final String XML_PREFIX = "Prefix";
    private static final String XML_USE_BASE_NAME = "UseBaseName";
    private static final String XML_SUFFIX = "Suffix";
    private static final String XML_BASE_NAME = "BaseName";

    public BasicNameBuilder(String prefix, String baseName, String suffix, boolean useBaseName) {
        this.setPrefix(prefix);
        this.setBaseName(baseName);
        this.setSuffix(suffix);
        this.setUseBaseName(useBaseName);
    }

    public static BasicNameBuilder fromXml(Element element) {
        String prefix = element.getAttribute(XML_PREFIX);
        String baseName = element.getAttribute(XML_BASE_NAME);
        String suffix = element.getAttribute(XML_SUFFIX);
        boolean useBaseName = XmlHelper.getAttrBool(element, XML_USE_BASE_NAME);
        BasicNameBuilder newBuilder = new BasicNameBuilder(prefix, baseName, suffix, useBaseName);
        return newBuilder;
    }

    @Override
    public String getBaseName() {
        return this.baseName_;
    }

    @Override
    public String getGeneratedName() {
        StringBuffer sb = new StringBuffer(this.getPrefix());
        if (this.getUseBaseName()) {
            sb.append(this.getBaseName());
        }
        sb.append(this.suffix_);
        return sb.toString();
    }

    @Override
    public String getPrefix() {
        return this.prefix_;
    }

    @Override
    public String getSuffix() {
        return this.suffix_;
    }

    @Override
    public boolean getUseBaseName() {
        return this.useBaseName_;
    }

    @Override
    public void setBaseName(String baseName) {
        this.baseName_ = baseName;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix_ = prefix;
    }

    @Override
    public void setSuffix(String suffix) {
        this.suffix_ = suffix;
    }

    @Override
    public void setUseBaseName(boolean use) {
        this.useBaseName_ = use;
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element element = doc.createElement(XML_CLASS);
        element.setAttribute(XML_PREFIX, this.getPrefix());
        XmlHelper.setAttr(element, XML_USE_BASE_NAME, this.getUseBaseName());
        element.setAttribute(XML_BASE_NAME, this.getBaseName());
        element.setAttribute(XML_SUFFIX, this.getSuffix());
        return element;
    }

    @Override
    public String getName() {
        return this.getGeneratedName();
    }

    @Override
    public void setName(String newName) {
    }
}

