/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.auth.pin;

import com.harrand.util.MathUtil;
import java.util.Calendar;

public class PIN_Hash {
    private final String hashCode;
    private Calendar purchased = null;

    public PIN_Hash(String hashCode) {
        this.hashCode = hashCode;
    }

    public PIN_Hash(String hashCode, int purchaseYear, int purchaseMonth, int purchaseDay) {
        this.hashCode = hashCode;
        this.setPurchased(purchaseYear, purchaseMonth, purchaseDay);
    }

    public String getHashCode() {
        return this.hashCode;
    }

    public Calendar getPurchased() {
        return this.purchased;
    }

    public final void setPurchased(int year, int month, int date) {
        this.purchased = Calendar.getInstance();
        this.purchased.set(year, month, date);
    }

    public boolean isPurchasedWithinYear(Calendar today) {
        if (this.isPurchasedSet()) {
            int daysElapsed = this.getDaysElapsed(today);
            return daysElapsed <= 365;
        }
        return false;
    }

    public int getDaysElapsed(Calendar today) {
        return MathUtil.getDaysElapsed(this.purchased, today);
    }

    private boolean isPurchasedSet() {
        return this.purchased != null;
    }
}

