/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.auth.lic.type;

import com.harrand.coreclasses.auth.lic.License;
import com.harrand.coreclasses.auth.lic.PurchaseOption;
import com.harrand.coreclasses.auth.lic.type.ILicenseType;
import com.harrand.util.MathUtil;
import java.util.Calendar;
import java.util.GregorianCalendar;

public final class PreviousVersionRecentLicenseType
implements ILicenseType {
    public static final int FREE_UPGRADE_WARN_DAYS = 15;
    public static String FREE_UPGRADES_UNTIL_MSG = "Your purchase of a 2.x  license entitles you to free version upgrades until: \n";
    public static String FREE_UPGRADES_FINISHED_MSG_A = "Your purchase of a 2.x  license entitled you to free version upgrades until: \n";
    public static String FREE_UPGRADES_FINISHED_MSG_B = "\nYou may continue to use this current version for as long as you wish. \nHowever you will need to purchase upgrade license to upgrade to a newer version.";
    public static final String NAME = "Version 2.x License (Purchased Within One Year)";

    @Override
    public String getWarningMsg(Calendar today) {
        return this.getFreeUpgradeWarningMsg();
    }

    @Override
    public String getFullDescr(Calendar today) {
        String descr = this.hasFreeUpgrades() ? this.getFreeUpgradesMsg() : this.getFreeUpgradesExpiredMsg();
        return descr;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getId() {
        return 8;
    }

    @Override
    public PurchaseOption getPurchaseOption() {
        return new PurchaseOption("Upgrade Now", "http://www.dbwrench.com/purchase/pp/purchase_pp_standard.shtml");
    }

    @Override
    public boolean getUsesUpgradeLicense() {
        return true;
    }

    @Override
    public boolean isOperableLicense() {
        return true;
    }

    private boolean hasFreeUpgrades() {
        GregorianCalendar today = new GregorianCalendar();
        Calendar freeUpgradeExpireDate = this.getFreeUpgradesExpireDate();
        boolean stillFree = today.getTimeInMillis() <= freeUpgradeExpireDate.getTimeInMillis();
        return stillFree;
    }

    private String getFreeUpgradeWarningMsg() {
        boolean isInWarningWindow;
        GregorianCalendar today = new GregorianCalendar();
        Calendar freeUpgradeExpireDate = this.getFreeUpgradesExpireDate();
        int daysRemaining = MathUtil.getDaysElapsed(today, freeUpgradeExpireDate);
        boolean isWithinOneYear = daysRemaining >= 0;
        boolean bl = isInWarningWindow = daysRemaining <= 15;
        if (isWithinOneYear && isInWarningWindow) {
            return this.getFreeUpgradesMsg();
        }
        return null;
    }

    private String getFreeUpgradesMsg() {
        String msg = FREE_UPGRADES_UNTIL_MSG + this.getFreeUpgradeExpireDateStr();
        return msg;
    }

    private String getFreeUpgradesExpiredMsg() {
        String msg = FREE_UPGRADES_FINISHED_MSG_A + this.getFreeUpgradeExpireDateStr() + FREE_UPGRADES_FINISHED_MSG_B;
        return msg;
    }

    private Calendar getFreeUpgradesExpireDate() {
        return this.getLicense().getFreeUpgradesExpireDate();
    }

    private String getFreeUpgradeExpireDateStr() {
        return this.getLicense().getFreeUpgradeExpireDateStr();
    }

    private License getLicense() {
        return License.getInstance();
    }
}

