/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.auth.lic.type;

import com.harrand.coreclasses.auth.lic.AppInfo;
import com.harrand.coreclasses.auth.lic.PurchaseOption;
import com.harrand.coreclasses.auth.lic.type.ILicenseType;
import com.harrand.coreclasses.auth.lic.type.TrialType;
import com.harrand.coreclasses.help.StrHelper;
import java.util.Calendar;

public class ExtendedTrialLicenseType
implements ILicenseType {
    public static final String NAME = "Extended Trial License";
    public static final int TRIAL_DAYS = 17;
    public static final int REMINDER_DAYS = 5;
    private static String TRIAL_WILD_CARD_MSG = TrialType.TRIAL_WILD_CARD_MSG;

    @Override
    public String getWarningMsg(Calendar today) {
        if (this.getDaysRemaining() <= 5) {
            return this.buildDescr();
        }
        return null;
    }

    @Override
    public String getFullDescr(Calendar today) {
        return this.buildDescr();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getId() {
        return 6;
    }

    @Override
    public PurchaseOption getPurchaseOption() {
        return new PurchaseOption("Purchase Now", "http://www.dbwrench.com/purchase/pp/purchase_pp_standard.shtml");
    }

    @Override
    public boolean getUsesUpgradeLicense() {
        return false;
    }

    @Override
    public boolean isOperableLicense() {
        return true;
    }

    private String buildDescr() {
        int daysRemaining = this.getDaysRemaining();
        String warningMsg = StrHelper.replaceWildCard(TRIAL_WILD_CARD_MSG, Integer.toString(daysRemaining));
        return warningMsg;
    }

    private int getDaysRemaining() {
        return AppInfo.getInstance().getDaysRemaining(17);
    }
}

