/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.auth.lic;

import com.harrand.coreclasses.auth.lic.AppInfo;
import com.harrand.coreclasses.auth.lic.License;
import com.harrand.coreclasses.auth.lic.LicensePolicy;
import com.harrand.coreclasses.auth.pin.IPIN;
import com.harrand.coreclasses.auth.pin.PIN_Factory;
import com.harrand.coreclasses.auth.pin.PIN_Hash;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.dataEntry.ObjectResult;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.security.Code;
import com.harrand.coreclasses.security.ICodeStore;
import java.util.GregorianCalendar;

public class LicensingCtrl
implements IObservable {
    private static final LicensingCtrl INSTANCE = new LicensingCtrl();
    private ICodeStore codeStore;
    private final BasicObservable observable_ = new BasicObservable();
    public static final String UNRECOGNIZED_LICENSE_KEY_TITLE = "Unrecognized License Key";
    public static final String UNRECOGNIZED_LICENSE_KEY_DETAIL = "The license key entered is not recognized as a valid key. \nPlease double check the key you entered.";

    private LicensingCtrl() {
    }

    public static LicensingCtrl getInstance() {
        return INSTANCE;
    }

    public void softwareInstalled() {
        AppInfo.getInstance().setInstallCalendar(new GregorianCalendar());
        this.refreshLicenseType();
    }

    public boolean getNeedsUpgradeLicense() {
        return LicensePolicy.getInstance().getNeedsUpgradeLicense();
    }

    public void setCodeStore(ICodeStore codeStore) {
        this.codeStore = codeStore;
        AppInfo.getInstance().setInstallCalendar(this.codeStore.getInstallCal());
        Code stdCode = this.codeStore.getCode();
        String stdPIN_Text = stdCode != null ? stdCode.getText() : "";
        this.setStandardPIN(stdPIN_Text);
        Code upgCode = this.codeStore.getV2UpgradeCode();
        String updPIN_Text = upgCode != null ? upgCode.getText() : "";
        this.setUpgradePIN(updPIN_Text);
    }

    public ITestResult setStandardPIN(String PIN_Text) {
        if (PIN_Text.equals("")) {
            return this.setStandardPIN_Disp(null, PIN_Text, null);
        }
        IPIN pin = this.createPIN(PIN_Text);
        if (pin != null) {
            ITestResult rslt = pin.validate();
            if (rslt.getPassed()) {
                ObjectResult objResult = (ObjectResult)rslt;
                PIN_Hash hash = (PIN_Hash)objResult.getObject();
                return this.setStandardPIN_Disp(pin, PIN_Text, hash);
            }
            return rslt;
        }
        return this.getUnrecognizedPinResult();
    }

    public ITestResult setUpgradePIN(String PIN_Text) {
        if (PIN_Text.equals("")) {
            return this.setUpgradePIN_Disp(null, PIN_Text, null);
        }
        IPIN pin = this.createPIN(PIN_Text);
        if (pin != null) {
            ITestResult rslt = pin.validate();
            if (rslt.getPassed()) {
                ObjectResult objResult = (ObjectResult)rslt;
                PIN_Hash hash = (PIN_Hash)objResult.getObject();
                return this.setUpgradePIN_Disp(pin, PIN_Text, hash);
            }
            return rslt;
        }
        return this.getUnrecognizedPinResult();
    }

    private ITestResult setStandardPIN_Disp(IPIN pin, String PIN_Text, PIN_Hash hash) {
        ITestResult rslt = this.getLicense().setStandardPIN(pin);
        this.getLicense().setStandardHash(hash);
        if (this.isCodeStoreSet()) {
            Code code = new Code(PIN_Text, 0);
            this.codeStore.setCode(code);
        }
        this.refreshLicenseType();
        this.notifyObservers(new UpdateChain(pin));
        return rslt;
    }

    private ITestResult setUpgradePIN_Disp(IPIN pin, String PIN_Text, PIN_Hash hash) {
        ITestResult rslt = this.getLicense().setUpgradePIN(pin);
        this.getLicense().setUpgradeHash(hash);
        if (this.isCodeStoreSet()) {
            Code code = new Code(PIN_Text, 1);
            this.codeStore.setV2UpgradeCode(code);
        }
        this.refreshLicenseType();
        this.notifyObservers(new UpdateChain(pin));
        return rslt;
    }

    private IPIN createPIN(String PIN_Text) {
        PIN_Factory pinFactory = PIN_Factory.getInstance();
        IPIN pin = pinFactory.createPIN(PIN_Text);
        return pin;
    }

    private boolean isCodeStoreSet() {
        return this.codeStore != null;
    }

    private ITestResult getUnrecognizedPinResult() {
        DataEntryResult rslt = new DataEntryResult(false, UNRECOGNIZED_LICENSE_KEY_TITLE, UNRECOGNIZED_LICENSE_KEY_DETAIL);
        return rslt;
    }

    private License getLicense() {
        return License.getInstance();
    }

    private void refreshLicenseType() {
        LicensePolicy.getInstance().refreshLicenseType();
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }
}

