/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coreclasses.auth.lic;

import com.harrand.coreclasses.auth.lic.AppInfo;
import com.harrand.coreclasses.auth.lic.type.ILicenseType;
import com.harrand.coreclasses.auth.lic.type.TrialType;
import com.harrand.coreclasses.auth.pin.ExtendedTrialPIN;
import com.harrand.coreclasses.auth.pin.IPIN;
import com.harrand.coreclasses.auth.pin.PIN_A;
import com.harrand.coreclasses.auth.pin.PIN_B;
import com.harrand.coreclasses.auth.pin.PIN_C;
import com.harrand.coreclasses.auth.pin.PIN_Hash;
import com.harrand.coreclasses.auth.pin.PIN_V3;
import com.harrand.coreclasses.auth.pin.PIN_V3_Upgrade;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class License {
    private ILicenseType licenseType = new TrialType();
    private IPIN standardPIN;
    private IPIN upgradePIN;
    private PIN_Hash standardHash;
    private PIN_Hash upgradeHash;
    private static License instance = new License();
    public static final String LICENSE_ENTRY_ERR_TITLE = "Licensing Key Entry Error";
    public static final String LICENSE_ENTRY_SUCCESS_TITLE = "License Key Entry Successful";
    public static final String LICENSE_CLEARED_TITLE = "License Key Cleared";
    public static final String STANDARD_AS_UPG_ERR = "Attempting to set standard PIN as a upgrade PIN.";
    public static final String UPG_AS_STANDARD_ERR = "Attempting to set an upgrade PIN as a standard PIN.";
    public static final String STANDARD_SUCCESS_MSG = "License key successfully entered and validated.";
    public static final String UPGRADE_SUCCESS_MSG = "Upgrade key successfully entered and validated.";
    public static final String LICENSE_CLEARED_MSG = "License key cleared.";
    public static final Calendar DEFAULT_PURCHASE_DATE = new GregorianCalendar(2010, 6, 1);

    public static License getInstance() {
        return instance;
    }

    public static void setInstance(License instance) {
        License.instance = instance;
    }

    private License() {
    }

    public ILicenseType getLicenseType() {
        return this.licenseType;
    }

    public IPIN getStandardPIN() {
        return this.standardPIN;
    }

    public IPIN getUpgradePIN() {
        return this.upgradePIN;
    }

    public void setLicenseType(ILicenseType licenseType) {
        this.licenseType = licenseType;
    }

    public void setStandardHash(PIN_Hash hash) {
        this.standardHash = hash;
    }

    public PIN_Hash getStandardHash() {
        return this.standardHash;
    }

    public PIN_Hash getUpgradeHash() {
        return this.upgradeHash;
    }

    public void setUpgradeHash(PIN_Hash upgradeHash) {
        this.upgradeHash = upgradeHash;
    }

    public ITestResult setStandardPIN(IPIN standardPIN) {
        ITestResult result;
        if (standardPIN == null) {
            this.standardPIN = null;
            result = this.getLicenseKeyClearedResult();
        } else if (standardPIN.isStandardPin()) {
            this.standardPIN = standardPIN;
            result = this.getInputSuccessResult(standardPIN, STANDARD_SUCCESS_MSG);
        } else {
            result = this.getInputErrResult(standardPIN, UPG_AS_STANDARD_ERR);
        }
        return result;
    }

    public ITestResult setUpgradePIN(IPIN upgradePIN) {
        ITestResult result;
        if (upgradePIN == null) {
            this.upgradePIN = null;
            result = this.getLicenseKeyClearedResult();
        } else if (!upgradePIN.isStandardPin()) {
            this.upgradePIN = upgradePIN;
            result = this.getInputSuccessResult(upgradePIN, UPGRADE_SUCCESS_MSG);
        } else {
            result = this.getInputErrResult(upgradePIN, STANDARD_AS_UPG_ERR);
        }
        return result;
    }

    boolean hasStandardPIN3x() {
        return this.standardPIN instanceof PIN_V3;
    }

    boolean hasUpgradePIN3x() {
        return this.upgradePIN instanceof PIN_V3_Upgrade;
    }

    public boolean hasStandardPIN2x() {
        return this.standardPIN instanceof PIN_B;
    }

    public boolean hasUpgradePIN2x() {
        return this.upgradePIN instanceof PIN_C;
    }

    public boolean hasStandardPIN1x() {
        return this.standardPIN instanceof PIN_A;
    }

    public boolean hasExtendedTrialPIN() {
        return this.standardPIN instanceof ExtendedTrialPIN;
    }

    public boolean isThisUpgradeFree() {
        Calendar versionReleaseDate = AppInfo.getInstance().getVersionReleaseDate();
        String releaseDateText = StrHelper.getCalendarAsMMMDDYYYY(versionReleaseDate);
        Calendar freeUpgradeExpireDate = this.getFreeUpgradesExpireDate();
        return versionReleaseDate.getTimeInMillis() <= freeUpgradeExpireDate.getTimeInMillis();
    }

    public Calendar getFreeUpgradesExpireDate() {
        Calendar purchaseDate = this.getPurchaseDate();
        Calendar freeUpgradeExpireDate = purchaseDate != null ? (Calendar)purchaseDate.clone() : (Calendar)DEFAULT_PURCHASE_DATE.clone();
        freeUpgradeExpireDate.add(1, 1);
        return freeUpgradeExpireDate;
    }

    public String getFreeUpgradeExpireDateStr() {
        Calendar freeUpgradeExpireDate = this.getFreeUpgradesExpireDate();
        return StrHelper.getCalendarAsMMMDDYYYY(freeUpgradeExpireDate);
    }

    private Calendar getPurchaseDate() {
        if (this.getStandardHash() == null) {
            return null;
        }
        Calendar latestPurchaseDate = null;
        if (this.upgradeHash != null) {
            latestPurchaseDate = this.upgradeHash.getPurchased();
        }
        if (latestPurchaseDate == null) {
            latestPurchaseDate = this.getStandardHash().getPurchased();
        }
        if (latestPurchaseDate != null) {
            return (Calendar)latestPurchaseDate.clone();
        }
        return null;
    }

    private String getPinTextDisplay(IPIN pin) {
        return " PIN: " + pin.getPIN_Text();
    }

    private ITestResult getInputErrResult(IPIN pin, String detail) {
        return new DataEntryResult(false, LICENSE_ENTRY_ERR_TITLE, detail + "\n" + this.getPinTextDisplay(pin));
    }

    private ITestResult getInputSuccessResult(IPIN pin, String detail) {
        return new DataEntryResult(true, LICENSE_ENTRY_SUCCESS_TITLE, detail + "\n" + this.getPinTextDisplay(pin));
    }

    private ITestResult getLicenseKeyClearedResult() {
        return new DataEntryResult(true, LICENSE_CLEARED_TITLE, LICENSE_CLEARED_MSG);
    }
}

