/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import freemarker.template.utility.UnrecognizedTimeZoneException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtil {
    public static final int ACCURACY_HOURS = 4;
    public static final int ACCURACY_MINUTES = 5;
    public static final int ACCURACY_SECONDS = 6;
    public static final int ACCURACY_MILLISECONDS = 7;
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final TimeZoneOffsetCalculator TIME_ZONE_OFFSET_CALCULATOR = DateUtil.getTimeZoneOffsetCalculator();

    private static TimeZoneOffsetCalculator getTimeZoneOffsetCalculator() {
        try {
            Class<?> cl = Class.forName("freemarker.template.utility.J2SE14TimeZoneOffsetCalculator");
            return (TimeZoneOffsetCalculator)cl.newInstance();
        }
        catch (Throwable e) {
            return new TimeZoneOffsetCalculator(){

                public int getOffset(TimeZone tz, Date date) {
                    throw new RuntimeException("Failed to create TimeZoneOffsetCalculator. Note that this feature requires at least Java 1.4.\nCause exception: " + e);
                }
            };
        }
    }

    private DateUtil() {
    }

    public static TimeZone getTimeZone(String name) throws UnrecognizedTimeZoneException {
        if (DateUtil.isGMTish(name)) {
            if (name.equalsIgnoreCase("UTC")) {
                return UTC;
            }
            return TimeZone.getTimeZone(name);
        }
        TimeZone tz = TimeZone.getTimeZone(name);
        if (DateUtil.isGMTish(tz.getID())) {
            throw new UnrecognizedTimeZoneException(name);
        }
        return tz;
    }

    private static boolean isGMTish(String name) {
        if (name.length() < 3) {
            return false;
        }
        char c1 = name.charAt(0);
        char c2 = name.charAt(1);
        char c3 = name.charAt(2);
        if ((c1 != 'G' && c1 != 'g' || c2 != 'M' && c2 != 'm' || c3 != 'T' && c3 != 't') && (c1 != 'U' && c1 != 'u' || c2 != 'T' && c2 != 't' || c3 != 'C' && c3 != 'c') && (c1 != 'U' && c1 != 'u' || c2 != 'T' && c2 != 't' || c3 != '1' && c3 != '1')) {
            return false;
        }
        if (name.length() == 3) {
            return true;
        }
        String offset = name.substring(3);
        if (offset.startsWith("+")) {
            return offset.equals("+0") || offset.equals("+00") || offset.equals("+00:00");
        }
        return offset.equals("-0") || offset.equals("-00") || offset.equals("-00:00");
    }

    public static String dateToISO8601String(Date date, boolean datePart, boolean timePart, boolean offsetPart, int accuracy, TimeZone timeZone, DateToISO8601CalendarFactory calendarFactory) {
        int x;
        if (!timePart && offsetPart) {
            throw new IllegalArgumentException("ISO 8601:2004 doesn't specify any formats where the offset is shown but the time isn't.");
        }
        if (timeZone == null) {
            timeZone = UTC;
        }
        GregorianCalendar cal = calendarFactory.get(timeZone, date);
        int maxLength = !timePart ? 10 : (!datePart ? 18 : 29);
        char[] res = new char[maxLength];
        int dstIdx = 0;
        if (datePart) {
            x = cal.get(1);
            if (x > 0 && cal.get(0) == 0) {
                x = -x + 1;
            }
            if (x >= 0 && x < 9999) {
                res[dstIdx++] = (char)(48 + x / 1000);
                res[dstIdx++] = (char)(48 + x % 1000 / 100);
                res[dstIdx++] = (char)(48 + x % 100 / 10);
                res[dstIdx++] = (char)(48 + x % 10);
            } else {
                String yearString = String.valueOf(x);
                maxLength = maxLength - 4 + yearString.length();
                res = new char[maxLength];
                for (int i = 0; i < yearString.length(); ++i) {
                    res[dstIdx++] = yearString.charAt(i);
                }
            }
            res[dstIdx++] = 45;
            x = cal.get(2) + 1;
            dstIdx = DateUtil.append00(res, dstIdx, x);
            res[dstIdx++] = 45;
            x = cal.get(5);
            dstIdx = DateUtil.append00(res, dstIdx, x);
            if (timePart) {
                res[dstIdx++] = 84;
            }
        }
        if (timePart) {
            x = cal.get(11);
            dstIdx = DateUtil.append00(res, dstIdx, x);
            if (accuracy >= 5) {
                res[dstIdx++] = 58;
                x = cal.get(12);
                dstIdx = DateUtil.append00(res, dstIdx, x);
                if (accuracy >= 6) {
                    res[dstIdx++] = 58;
                    x = cal.get(13);
                    dstIdx = DateUtil.append00(res, dstIdx, x);
                    if (accuracy >= 7 && (x = cal.get(14)) != 0) {
                        if (x > 999) {
                            throw new RuntimeException("Calendar.MILLISECOND > 999");
                        }
                        res[dstIdx++] = 46;
                        do {
                            res[dstIdx++] = (char)(48 + x / 100);
                        } while ((x = x % 100 * 10) != 0);
                    }
                }
            }
        }
        if (offsetPart) {
            if (timeZone == UTC) {
                res[dstIdx++] = 90;
            } else {
                boolean positive;
                int dt = TIME_ZONE_OFFSET_CALCULATOR.getOffset(timeZone, date);
                if (dt < 0) {
                    positive = false;
                    dt = -dt;
                } else {
                    positive = true;
                }
                int offS = (dt /= 1000) % 60;
                int offM = (dt /= 60) % 60;
                int offH = dt /= 60;
                if (offS == 0 && offM == 0 && offH == 0) {
                    res[dstIdx++] = 90;
                } else {
                    res[dstIdx++] = positive ? 43 : 45;
                    dstIdx = DateUtil.append00(res, dstIdx, offH);
                    res[dstIdx++] = 58;
                    dstIdx = DateUtil.append00(res, dstIdx, offM);
                    if (offS != 0) {
                        res[dstIdx++] = 58;
                        dstIdx = DateUtil.append00(res, dstIdx, offS);
                    }
                }
            }
        }
        return new String(res, 0, dstIdx);
    }

    private static int append00(char[] res, int dstIdx, int x) {
        res[dstIdx++] = (char)(48 + x / 10);
        res[dstIdx++] = (char)(48 + x % 10);
        return dstIdx;
    }

    public static interface DateToISO8601CalendarFactory {
        public GregorianCalendar get(TimeZone var1, Date var2);
    }

    static interface TimeZoneOffsetCalculator {
        public int getOffset(TimeZone var1, Date var2);
    }

    public static final class TrivialDateToISO8601CalendarFactory
    implements DateToISO8601CalendarFactory {
        private GregorianCalendar calendar;

        public GregorianCalendar get(TimeZone tz, Date date) {
            if (this.calendar == null) {
                this.calendar = new GregorianCalendar(tz, Locale.US);
            } else {
                this.calendar.setTimeZone(tz);
            }
            this.calendar.setTime(date);
            return this.calendar;
        }
    }
}

