/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BodyInstruction;
import freemarker.core.BreakInstruction;
import freemarker.core.Configurable;
import freemarker.core.Expression;
import freemarker.core.Identifier;
import freemarker.core.Include;
import freemarker.core.InvalidReferenceException;
import freemarker.core.IteratorBlock;
import freemarker.core.LocalContext;
import freemarker.core.Macro;
import freemarker.core.ReturnInstruction;
import freemarker.core.StopException;
import freemarker.core.TemplateElement;
import freemarker.core.UnifiedCall;
import freemarker.ext.beans.BeansWrapper;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import freemarker.template.Template;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.TemplateTransformModel;
import freemarker.template.TransformControl;
import freemarker.template.WrappingTemplateModel;
import freemarker.template.utility.DateUtil;
import freemarker.template.utility.StringUtil;
import freemarker.template.utility.UndeclaredThrowableException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.Collator;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;

public final class Environment
extends Configurable {
    private static final ThreadLocal threadEnv = new ThreadLocal();
    private static final Logger logger = Logger.getLogger("freemarker.runtime");
    private static final Logger attemptLogger = Logger.getLogger("freemarker.runtime.attempt");
    private static final Map localizedNumberFormats = new HashMap();
    private static final Map localizedDateFormats = new HashMap();
    private static final DecimalFormat C_NUMBER_FORMAT = new DecimalFormat("0.################", new DecimalFormatSymbols(Locale.US));
    private final TemplateHashModel rootDataModel;
    private final ArrayList elementStack = new ArrayList();
    private final ArrayList recoveredErrorStack = new ArrayList();
    private NumberFormat numberFormat;
    private Map numberFormats;
    private DateFormat timeFormat;
    private DateFormat dateFormat;
    private DateFormat dateTimeFormat;
    private Map[] dateFormats;
    private NumberFormat cNumberFormat;
    private DateUtil.DateToISO8601CalendarFactory isoBuiltInCalendarFactory;
    private Collator collator;
    private Writer out;
    private Macro.Context currentMacroContext;
    private ArrayList localContextStack;
    private Namespace mainNamespace;
    private Namespace currentNamespace;
    private Namespace globalNamespace;
    private HashMap loadedLibs;
    private Throwable lastThrowable;
    private TemplateModel lastReturnValue;
    private HashMap macroToNamespaceLookup = new HashMap();
    private TemplateNodeModel currentVisitorNode;
    private TemplateSequenceModel nodeNamespaces;
    private int nodeNamespaceIndex;
    private String currentNodeName;
    private String currentNodeNS;
    private String cachedURLEscapingCharset;
    private boolean urlEscapingCharsetCached;
    private static final TemplateModel[] NO_OUT_ARGS;
    static final Writer NULL_WRITER;
    private static final Writer EMPTY_BODY_WRITER;

    public static Environment getCurrentEnvironment() {
        return (Environment)threadEnv.get();
    }

    public Environment(Template template, TemplateHashModel rootDataModel, Writer out) {
        super(template);
        this.globalNamespace = new Namespace(null);
        this.currentNamespace = this.mainNamespace = new Namespace(template);
        this.out = out;
        this.rootDataModel = rootDataModel;
        this.importMacros(template);
    }

    public Template getTemplate() {
        return (Template)this.getParent();
    }

    private void clearCachedValues() {
        this.numberFormats = null;
        this.numberFormat = null;
        this.dateFormats = null;
        this.collator = null;
        this.cachedURLEscapingCharset = null;
        this.urlEscapingCharsetCached = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws TemplateException, IOException {
        Object savedEnv = threadEnv.get();
        threadEnv.set(this);
        try {
            this.clearCachedValues();
            try {
                this.doAutoImportsAndIncludes(this);
                this.visit(this.getTemplate().getRootTreeNode());
                if (this.getAutoFlush()) {
                    this.out.flush();
                }
            }
            finally {
                this.clearCachedValues();
            }
        }
        finally {
            threadEnv.set(savedEnv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visit(TemplateElement element) throws TemplateException, IOException {
        this.pushElement(element);
        try {
            element.accept(this);
        }
        catch (TemplateException te) {
            this.handleTemplateException(te);
        }
        finally {
            this.popElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(final TemplateElement element, TemplateDirectiveModel directiveModel, Map args, final List bodyParameterNames) throws TemplateException, IOException {
        TemplateDirectiveBody nested = element == null ? null : new TemplateDirectiveBody(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void render(Writer newOut) throws TemplateException, IOException {
                Writer prevOut = Environment.this.out;
                Environment.this.out = newOut;
                try {
                    Environment.this.visit(element);
                }
                finally {
                    Environment.this.out = prevOut;
                }
            }
        };
        final TemplateModel[] outArgs = bodyParameterNames == null || bodyParameterNames.isEmpty() ? NO_OUT_ARGS : new TemplateModel[bodyParameterNames.size()];
        if (outArgs.length > 0) {
            this.pushLocalContext(new LocalContext(){

                public TemplateModel getLocalVariable(String name) {
                    int index = bodyParameterNames.indexOf(name);
                    return index != -1 ? outArgs[index] : null;
                }

                public Collection getLocalVariableNames() {
                    return bodyParameterNames;
                }
            });
        }
        try {
            directiveModel.execute(this, args, outArgs, nested);
        }
        finally {
            if (outArgs.length > 0) {
                this.popLocalContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visit(TemplateElement element, TemplateTransformModel transform, Map args) throws TemplateException, IOException {
        block17: {
            try {
                Writer tw = transform.getWriter(this.out, args);
                if (tw == null) {
                    tw = EMPTY_BODY_WRITER;
                }
                TransformControl tc = tw instanceof TransformControl ? (TransformControl)((Object)tw) : null;
                Writer prevOut = this.out;
                this.out = tw;
                try {
                    if (tc == null || tc.onStart() != 0) {
                        do {
                            if (element == null) continue;
                            this.visit(element);
                        } while (tc != null && tc.afterBody() == 0);
                    }
                }
                catch (Throwable t) {
                    try {
                        if (tc != null) {
                            tc.onError(t);
                            break block17;
                        }
                        throw t;
                    }
                    catch (TemplateException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new UndeclaredThrowableException(e);
                    }
                }
                finally {
                    this.out = prevOut;
                    tw.close();
                }
            }
            catch (TemplateException te) {
                this.handleTemplateException(te);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visit(TemplateElement attemptBlock, TemplateElement recoveryBlock) throws TemplateException, IOException {
        Writer prevOut = this.out;
        StringWriter sw = new StringWriter();
        this.out = sw;
        TemplateException thrownException = null;
        try {
            this.visit(attemptBlock);
        }
        catch (TemplateException te) {
            thrownException = te;
        }
        finally {
            this.out = prevOut;
        }
        if (thrownException != null) {
            if (attemptLogger.isDebugEnabled()) {
                attemptLogger.debug("Error in attempt block " + attemptBlock.getStartLocationQuoted(), thrownException);
            }
            try {
                this.recoveredErrorStack.add(thrownException.getMessage());
                this.visit(recoveryBlock);
            }
            finally {
                this.recoveredErrorStack.remove(this.recoveredErrorStack.size() - 1);
            }
        } else {
            this.out.write(sw.toString());
        }
    }

    String getCurrentRecoveredErrorMesssage() throws TemplateException {
        if (this.recoveredErrorStack.isEmpty()) {
            throw new TemplateException(".error is not available outside of a <#recover> block", this);
        }
        return (String)this.recoveredErrorStack.get(this.recoveredErrorStack.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visit(BodyInstruction.Context bctxt) throws TemplateException, IOException {
        Macro.Context invokingMacroContext = this.getCurrentMacroContext();
        ArrayList prevLocalContextStack = this.localContextStack;
        TemplateElement body = invokingMacroContext.body;
        if (body != null) {
            this.currentMacroContext = invokingMacroContext.prevMacroContext;
            this.currentNamespace = invokingMacroContext.bodyNamespace;
            Configurable prevParent = this.getParent();
            this.setParent(this.currentNamespace.getTemplate());
            this.localContextStack = invokingMacroContext.prevLocalContextStack;
            if (invokingMacroContext.bodyParameterNames != null) {
                this.pushLocalContext(bctxt);
            }
            try {
                this.visit(body);
            }
            finally {
                if (invokingMacroContext.bodyParameterNames != null) {
                    this.popLocalContext();
                }
                this.currentMacroContext = invokingMacroContext;
                this.currentNamespace = this.getMacroNamespace(invokingMacroContext.getMacro());
                this.setParent(prevParent);
                this.localContextStack = prevLocalContextStack;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visit(IteratorBlock.Context ictxt) throws TemplateException, IOException {
        this.pushLocalContext(ictxt);
        try {
            ictxt.runLoop(this);
        }
        catch (BreakInstruction.Break br) {
        }
        catch (TemplateException te) {
            this.handleTemplateException(te);
        }
        finally {
            this.popLocalContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visit(TemplateNodeModel node, TemplateSequenceModel namespaces) throws TemplateException, IOException {
        block15: {
            if (this.nodeNamespaces == null) {
                SimpleSequence ss = new SimpleSequence(1);
                ss.add(this.currentNamespace);
                this.nodeNamespaces = ss;
            }
            int prevNodeNamespaceIndex = this.nodeNamespaceIndex;
            String prevNodeName = this.currentNodeName;
            String prevNodeNS = this.currentNodeNS;
            TemplateSequenceModel prevNodeNamespaces = this.nodeNamespaces;
            TemplateNodeModel prevVisitorNode = this.currentVisitorNode;
            this.currentVisitorNode = node;
            if (namespaces != null) {
                this.nodeNamespaces = namespaces;
            }
            try {
                TemplateModel macroOrTransform = this.getNodeProcessor(node);
                if (macroOrTransform instanceof Macro) {
                    this.visit((Macro)macroOrTransform, null, null, null, null);
                    break block15;
                }
                if (macroOrTransform instanceof TemplateTransformModel) {
                    this.visit(null, (TemplateTransformModel)macroOrTransform, null);
                    break block15;
                }
                String nodeType = node.getNodeType();
                if (nodeType != null) {
                    if (nodeType.equals("text") && node instanceof TemplateScalarModel) {
                        this.out.write(((TemplateScalarModel)((Object)node)).getAsString());
                    } else if (nodeType.equals("document")) {
                        this.recurse(node, namespaces);
                    } else if (!(nodeType.equals("pi") || nodeType.equals("comment") || nodeType.equals("document_type"))) {
                        String nsBit = "";
                        String ns = node.getNodeNamespace();
                        if (ns != null) {
                            nsBit = ns.length() > 0 ? " and namespace " + ns : " and no namespace";
                        }
                        throw new TemplateException("No macro or transform defined for node named " + node.getNodeName() + nsBit + ", and there is no fallback handler called @" + nodeType + " either.", this);
                    }
                    break block15;
                }
                String nsBit = "";
                String ns = node.getNodeNamespace();
                if (ns != null) {
                    nsBit = ns.length() > 0 ? " and namespace " + ns : " and no namespace";
                }
                throw new TemplateException("No macro or transform defined for node with name " + node.getNodeName() + nsBit + ", and there is no macro or transform called @default either.", this);
            }
            finally {
                this.currentVisitorNode = prevVisitorNode;
                this.nodeNamespaceIndex = prevNodeNamespaceIndex;
                this.currentNodeName = prevNodeName;
                this.currentNodeNS = prevNodeNS;
                this.nodeNamespaces = prevNodeNamespaces;
            }
        }
    }

    void fallback() throws TemplateException, IOException {
        TemplateModel macroOrTransform = this.getNodeProcessor(this.currentNodeName, this.currentNodeNS, this.nodeNamespaceIndex);
        if (macroOrTransform instanceof Macro) {
            this.visit((Macro)macroOrTransform, null, null, null, null);
        } else if (macroOrTransform instanceof TemplateTransformModel) {
            this.visit(null, (TemplateTransformModel)macroOrTransform, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void visit(Macro macro, Map namedArgs, List positionalArgs, List bodyParameterNames, TemplateElement nestedBlock) throws TemplateException, IOException {
        block25: {
            if (macro == Macro.DO_NOTHING_MACRO) {
                return;
            }
            this.pushElement(macro);
            try {
                Macro.Context previousMacroContext = this.currentMacroContext;
                Macro macro2 = macro;
                macro2.getClass();
                Macro.Context mc = new Macro.Context(macro2, this, nestedBlock, bodyParameterNames);
                String catchAll = macro.getCatchAll();
                WrappingTemplateModel unknownVars = null;
                if (namedArgs != null) {
                    if (catchAll != null) {
                        unknownVars = new SimpleHash();
                    }
                    Iterator it = namedArgs.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        String varName = (String)entry.getKey();
                        boolean hasVar = macro.hasArgNamed(varName);
                        if (hasVar || catchAll != null) {
                            Expression arg = (Expression)entry.getValue();
                            TemplateModel value = arg.getAsTemplateModel(this);
                            if (hasVar) {
                                mc.setLocalVar(varName, value);
                                continue;
                            }
                            ((SimpleHash)unknownVars).put(varName, value);
                            continue;
                        }
                        String msg = "Macro " + macro.getName() + " has no such argument: " + varName;
                        throw new TemplateException(msg, this);
                    }
                } else if (positionalArgs != null) {
                    int size;
                    String[] argumentNames;
                    if (catchAll != null) {
                        unknownVars = new SimpleSequence();
                    }
                    if ((argumentNames = macro.getArgumentNamesInternal()).length < (size = positionalArgs.size()) && catchAll == null) {
                        throw new TemplateException("Macro " + macro.getName() + " only accepts " + argumentNames.length + " parameters.", this);
                    }
                    for (int i = 0; i < size; ++i) {
                        Expression argExp = (Expression)positionalArgs.get(i);
                        TemplateModel argModel = argExp.getAsTemplateModel(this);
                        try {
                            if (i < argumentNames.length) {
                                String argName = argumentNames[i];
                                mc.setLocalVar(argName, argModel);
                                continue;
                            }
                            ((SimpleSequence)unknownVars).add(argModel);
                            continue;
                        }
                        catch (RuntimeException re) {
                            throw new TemplateException(re, this);
                        }
                    }
                }
                if (catchAll != null) {
                    mc.setLocalVar(catchAll, (TemplateModel)((Object)unknownVars));
                }
                ArrayList prevLocalContextStack = this.localContextStack;
                this.localContextStack = null;
                Namespace prevNamespace = this.currentNamespace;
                Configurable prevParent = this.getParent();
                this.currentNamespace = (Namespace)this.macroToNamespaceLookup.get(macro);
                this.currentMacroContext = mc;
                try {
                    mc.runMacro(this);
                }
                catch (ReturnInstruction.Return re) {
                    this.currentMacroContext = previousMacroContext;
                    this.localContextStack = prevLocalContextStack;
                    this.currentNamespace = prevNamespace;
                    this.setParent(prevParent);
                }
                catch (TemplateException te) {
                    this.handleTemplateException(te);
                    break block25;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.currentMacroContext = previousMacroContext;
                    this.localContextStack = prevLocalContextStack;
                    this.currentNamespace = prevNamespace;
                    this.setParent(prevParent);
                }
            }
            finally {
                this.popElement();
            }
        }
    }

    void visitMacroDef(Macro macro) {
        this.macroToNamespaceLookup.put(macro, this.currentNamespace);
        this.currentNamespace.put(macro.getName(), macro);
    }

    Namespace getMacroNamespace(Macro macro) {
        return (Namespace)this.macroToNamespaceLookup.get(macro);
    }

    void recurse(TemplateNodeModel node, TemplateSequenceModel namespaces) throws TemplateException, IOException {
        if (node == null && (node = this.getCurrentVisitorNode()) == null) {
            throw new TemplateModelException("The target node of recursion is missing or null.");
        }
        TemplateSequenceModel children = node.getChildNodes();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            TemplateNodeModel child = (TemplateNodeModel)children.get(i);
            if (child == null) continue;
            this.visit(child, namespaces);
        }
    }

    Macro.Context getCurrentMacroContext() {
        return this.currentMacroContext;
    }

    private void handleTemplateException(TemplateException te) throws TemplateException {
        if (this.lastThrowable == te) {
            throw te;
        }
        this.lastThrowable = te;
        if (logger.isErrorEnabled()) {
            logger.error("Template processing error: " + StringUtil.jQuoteNoXSS(te.getMessage()), te);
        }
        if (te instanceof StopException) {
            throw te;
        }
        this.getTemplateExceptionHandler().handleTemplateException(te, this, this.out);
    }

    public void setTemplateExceptionHandler(TemplateExceptionHandler templateExceptionHandler) {
        super.setTemplateExceptionHandler(templateExceptionHandler);
        this.lastThrowable = null;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.numberFormats = null;
        this.numberFormat = null;
        this.dateFormats = null;
        this.dateTimeFormat = null;
        this.dateFormat = null;
        this.timeFormat = null;
        this.collator = null;
    }

    public void setTimeZone(TimeZone timeZone) {
        super.setTimeZone(timeZone);
        this.dateFormats = null;
        this.dateTimeFormat = null;
        this.dateFormat = null;
        this.timeFormat = null;
    }

    public void setURLEscapingCharset(String urlEscapingCharset) {
        this.urlEscapingCharsetCached = false;
        super.setURLEscapingCharset(urlEscapingCharset);
    }

    public void setOutputEncoding(String outputEncoding) {
        this.urlEscapingCharsetCached = false;
        super.setOutputEncoding(outputEncoding);
    }

    String getEffectiveURLEscapingCharset() {
        if (!this.urlEscapingCharsetCached) {
            this.cachedURLEscapingCharset = this.getURLEscapingCharset();
            if (this.cachedURLEscapingCharset == null) {
                this.cachedURLEscapingCharset = this.getOutputEncoding();
            }
            this.urlEscapingCharsetCached = true;
        }
        return this.cachedURLEscapingCharset;
    }

    Collator getCollator() {
        if (this.collator == null) {
            this.collator = Collator.getInstance(this.getLocale());
        }
        return this.collator;
    }

    public void setOut(Writer out) {
        this.out = out;
    }

    public Writer getOut() {
        return this.out;
    }

    String formatNumber(Number number) {
        if (this.numberFormat == null) {
            this.numberFormat = this.getNumberFormatObject(this.getNumberFormat());
        }
        return this.numberFormat.format(number);
    }

    public void setNumberFormat(String formatName) {
        super.setNumberFormat(formatName);
        this.numberFormat = null;
    }

    String formatDate(Date date, int type) throws TemplateModelException {
        DateFormat df = this.getDateFormatObject(type);
        if (df == null) {
            throw new TemplateModelException("Can't convert the date to string, because it is not known which parts of the date variable are in use. Use ?date, ?time or ?datetime built-in, or ?string.<format> or ?string(format) built-in with this date.");
        }
        return df.format(date);
    }

    public void setTimeFormat(String formatName) {
        super.setTimeFormat(formatName);
        this.timeFormat = null;
    }

    public void setDateFormat(String formatName) {
        super.setDateFormat(formatName);
        this.dateFormat = null;
    }

    public void setDateTimeFormat(String formatName) {
        super.setDateTimeFormat(formatName);
        this.dateTimeFormat = null;
    }

    public Configuration getConfiguration() {
        return this.getTemplate().getConfiguration();
    }

    TemplateModel getLastReturnValue() {
        return this.lastReturnValue;
    }

    void setLastReturnValue(TemplateModel lastReturnValue) {
        this.lastReturnValue = lastReturnValue;
    }

    void clearLastReturnValue() {
        this.lastReturnValue = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NumberFormat getNumberFormatObject(String pattern) {
        NumberFormat format;
        if (this.numberFormats == null) {
            this.numberFormats = new HashMap();
        }
        if ((format = (NumberFormat)this.numberFormats.get(pattern)) != null) {
            return format;
        }
        Map map = localizedNumberFormats;
        synchronized (map) {
            Locale locale = this.getLocale();
            NumberFormatKey fk = new NumberFormatKey(pattern, locale);
            format = (NumberFormat)localizedNumberFormats.get(fk);
            if (format == null) {
                format = "number".equals(pattern) ? NumberFormat.getNumberInstance(locale) : ("currency".equals(pattern) ? NumberFormat.getCurrencyInstance(locale) : ("percent".equals(pattern) ? NumberFormat.getPercentInstance(locale) : ("computer".equals(pattern) ? this.getCNumberFormat() : new DecimalFormat(pattern, new DecimalFormatSymbols(this.getLocale())))));
                localizedNumberFormats.put(fk, format);
            }
        }
        format = (NumberFormat)format.clone();
        this.numberFormats.put(pattern, format);
        return format;
    }

    DateFormat getDateFormatObject(int dateType) throws TemplateModelException {
        switch (dateType) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.timeFormat == null) {
                    this.timeFormat = this.getDateFormatObject(dateType, this.getTimeFormat());
                }
                return this.timeFormat;
            }
            case 2: {
                if (this.dateFormat == null) {
                    this.dateFormat = this.getDateFormatObject(dateType, this.getDateFormat());
                }
                return this.dateFormat;
            }
            case 3: {
                if (this.dateTimeFormat == null) {
                    this.dateTimeFormat = this.getDateFormatObject(dateType, this.getDateTimeFormat());
                }
                return this.dateTimeFormat;
            }
        }
        throw new TemplateModelException("Unrecognized date type " + dateType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DateFormat getDateFormatObject(int dateType, String pattern) throws TemplateModelException {
        Map typedDateFormat;
        DateFormat format;
        if (this.dateFormats == null) {
            this.dateFormats = new Map[4];
            this.dateFormats[0] = new HashMap();
            this.dateFormats[1] = new HashMap();
            this.dateFormats[2] = new HashMap();
            this.dateFormats[3] = new HashMap();
        }
        if ((format = (DateFormat)(typedDateFormat = this.dateFormats[dateType]).get(pattern)) != null) {
            return format;
        }
        Map map = localizedDateFormats;
        synchronized (map) {
            Locale locale = this.getLocale();
            TimeZone timeZone = this.getTimeZone();
            DateFormatKey fk = new DateFormatKey(dateType, pattern, locale, timeZone);
            format = (DateFormat)localizedDateFormats.get(fk);
            if (format == null) {
                int style;
                StringTokenizer tok = new StringTokenizer(pattern, "_");
                int n = style = tok.hasMoreTokens() ? this.parseDateStyleToken(tok.nextToken()) : 2;
                if (style != -1) {
                    switch (dateType) {
                        case 0: {
                            throw new TemplateModelException("Can't convert the date to string using a built-in format, because it is not known which parts of the date variable are in use. Use ?date, ?time or ?datetime built-in, or ?string.<format> or ?string(<format>) built-in with explicit formatting pattern with this date.");
                        }
                        case 1: {
                            format = DateFormat.getTimeInstance(style, locale);
                            break;
                        }
                        case 2: {
                            format = DateFormat.getDateInstance(style, locale);
                            break;
                        }
                        case 3: {
                            int timestyle;
                            int n2 = timestyle = tok.hasMoreTokens() ? this.parseDateStyleToken(tok.nextToken()) : style;
                            if (timestyle == -1) break;
                            format = DateFormat.getDateTimeInstance(style, timestyle, locale);
                            break;
                        }
                    }
                }
                if (format == null) {
                    try {
                        format = new SimpleDateFormat(pattern, locale);
                    }
                    catch (IllegalArgumentException e) {
                        throw new TemplateModelException("Can't parse " + pattern + " to a date format.", e);
                    }
                }
                format.setTimeZone(timeZone);
                localizedDateFormats.put(fk, format);
            }
        }
        format = (DateFormat)format.clone();
        typedDateFormat.put(pattern, format);
        return format;
    }

    int parseDateStyleToken(String token) {
        if ("short".equals(token)) {
            return 3;
        }
        if ("medium".equals(token)) {
            return 2;
        }
        if ("long".equals(token)) {
            return 1;
        }
        if ("full".equals(token)) {
            return 0;
        }
        return -1;
    }

    DateUtil.DateToISO8601CalendarFactory getISOBuiltInCalendar() {
        if (this.isoBuiltInCalendarFactory == null) {
            this.isoBuiltInCalendarFactory = new DateUtil.TrivialDateToISO8601CalendarFactory();
        }
        return this.isoBuiltInCalendarFactory;
    }

    public NumberFormat getCNumberFormat() {
        if (this.cNumberFormat == null) {
            this.cNumberFormat = (DecimalFormat)C_NUMBER_FORMAT.clone();
        }
        return this.cNumberFormat;
    }

    TemplateTransformModel getTransform(Expression exp) throws TemplateException {
        TemplateTransformModel ttm = null;
        TemplateModel tm = exp.getAsTemplateModel(this);
        if (tm instanceof TemplateTransformModel) {
            ttm = (TemplateTransformModel)tm;
        } else if (exp instanceof Identifier && (tm = this.getConfiguration().getSharedVariable(exp.toString())) instanceof TemplateTransformModel) {
            ttm = (TemplateTransformModel)tm;
        }
        return ttm;
    }

    public TemplateModel getLocalVariable(String name) throws TemplateModelException {
        if (this.localContextStack != null) {
            for (int i = this.localContextStack.size() - 1; i >= 0; --i) {
                LocalContext lc = (LocalContext)this.localContextStack.get(i);
                TemplateModel tm = lc.getLocalVariable(name);
                if (tm == null) continue;
                return tm;
            }
        }
        return this.currentMacroContext == null ? null : this.currentMacroContext.getLocalVariable(name);
    }

    public TemplateModel getVariable(String name) throws TemplateModelException {
        TemplateModel result = this.getLocalVariable(name);
        if (result == null) {
            result = this.currentNamespace.get(name);
        }
        if (result == null) {
            result = this.getGlobalVariable(name);
        }
        return result;
    }

    public TemplateModel getGlobalVariable(String name) throws TemplateModelException {
        TemplateModel result = this.globalNamespace.get(name);
        if (result == null) {
            result = this.rootDataModel.get(name);
        }
        if (result == null) {
            result = this.getConfiguration().getSharedVariable(name);
        }
        return result;
    }

    public void setGlobalVariable(String name, TemplateModel model) {
        this.globalNamespace.put(name, model);
    }

    public void setVariable(String name, TemplateModel model) {
        this.currentNamespace.put(name, model);
    }

    public void setLocalVariable(String name, TemplateModel model) {
        if (this.currentMacroContext == null) {
            throw new IllegalStateException("Not executing macro body");
        }
        this.currentMacroContext.setLocalVar(name, model);
    }

    public Set getKnownVariableNames() throws TemplateModelException {
        Set set = this.getConfiguration().getSharedVariableNames();
        if (this.rootDataModel instanceof TemplateHashModelEx) {
            TemplateModelIterator rootNames = ((TemplateHashModelEx)this.rootDataModel).keys().iterator();
            while (rootNames.hasNext()) {
                set.add(((TemplateScalarModel)rootNames.next()).getAsString());
            }
        }
        TemplateModelIterator tmi = this.globalNamespace.keys().iterator();
        while (tmi.hasNext()) {
            set.add(((TemplateScalarModel)tmi.next()).getAsString());
        }
        tmi = this.currentNamespace.keys().iterator();
        while (tmi.hasNext()) {
            set.add(((TemplateScalarModel)tmi.next()).getAsString());
        }
        if (this.currentMacroContext != null) {
            set.addAll(this.currentMacroContext.getLocalVariableNames());
        }
        if (this.localContextStack != null) {
            for (int i = this.localContextStack.size() - 1; i >= 0; --i) {
                LocalContext lc = (LocalContext)this.localContextStack.get(i);
                set.addAll(lc.getLocalVariableNames());
            }
        }
        return set;
    }

    public void outputInstructionStack(PrintWriter pw) {
        TemplateElement prev;
        pw.println("----------");
        ListIterator iter = this.elementStack.listIterator(this.elementStack.size());
        if (iter.hasPrevious()) {
            pw.print("==> ");
            prev = (TemplateElement)iter.previous();
            pw.print(prev.getDescription());
            pw.print(" [");
            pw.print(prev.getStartLocation());
            pw.println("]");
        }
        while (iter.hasPrevious()) {
            String location;
            prev = (TemplateElement)iter.previous();
            if (!(prev instanceof UnifiedCall) && !(prev instanceof Include) || (location = prev.getDescription() + " [" + prev.getStartLocation() + "]") == null || location.length() <= 0) continue;
            pw.print(" in ");
            pw.println(location);
        }
        pw.println("----------");
        pw.flush();
    }

    private void pushLocalContext(LocalContext localContext) {
        if (this.localContextStack == null) {
            this.localContextStack = new ArrayList();
        }
        this.localContextStack.add(localContext);
    }

    private void popLocalContext() {
        this.localContextStack.remove(this.localContextStack.size() - 1);
    }

    ArrayList getLocalContextStack() {
        return this.localContextStack;
    }

    public Namespace getNamespace(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (this.loadedLibs != null) {
            return (Namespace)this.loadedLibs.get(name);
        }
        return null;
    }

    public Namespace getMainNamespace() {
        return this.mainNamespace;
    }

    public Namespace getCurrentNamespace() {
        return this.currentNamespace;
    }

    public Namespace getGlobalNamespace() {
        return this.globalNamespace;
    }

    public TemplateHashModel getDataModel() {
        final TemplateHashModel result = new TemplateHashModel(){

            public boolean isEmpty() {
                return false;
            }

            public TemplateModel get(String key) throws TemplateModelException {
                TemplateModel value = Environment.this.rootDataModel.get(key);
                if (value == null) {
                    value = Environment.this.getConfiguration().getSharedVariable(key);
                }
                return value;
            }
        };
        if (this.rootDataModel instanceof TemplateHashModelEx) {
            return new TemplateHashModelEx(){

                public boolean isEmpty() throws TemplateModelException {
                    return result.isEmpty();
                }

                public TemplateModel get(String key) throws TemplateModelException {
                    return result.get(key);
                }

                public TemplateCollectionModel values() throws TemplateModelException {
                    return ((TemplateHashModelEx)Environment.this.rootDataModel).values();
                }

                public TemplateCollectionModel keys() throws TemplateModelException {
                    return ((TemplateHashModelEx)Environment.this.rootDataModel).keys();
                }

                public int size() throws TemplateModelException {
                    return ((TemplateHashModelEx)Environment.this.rootDataModel).size();
                }
            };
        }
        return result;
    }

    public TemplateHashModel getGlobalVariables() {
        return new TemplateHashModel(){

            public boolean isEmpty() {
                return false;
            }

            public TemplateModel get(String key) throws TemplateModelException {
                TemplateModel result = Environment.this.globalNamespace.get(key);
                if (result == null) {
                    result = Environment.this.rootDataModel.get(key);
                }
                if (result == null) {
                    result = Environment.this.getConfiguration().getSharedVariable(key);
                }
                return result;
            }
        };
    }

    private void pushElement(TemplateElement element) {
        this.elementStack.add(element);
    }

    private void popElement() {
        this.elementStack.remove(this.elementStack.size() - 1);
    }

    public TemplateNodeModel getCurrentVisitorNode() {
        return this.currentVisitorNode;
    }

    public void setCurrentVisitorNode(TemplateNodeModel node) {
        this.currentVisitorNode = node;
    }

    TemplateModel getNodeProcessor(TemplateNodeModel node) throws TemplateException {
        String nodeName = node.getNodeName();
        if (nodeName == null) {
            throw new TemplateException("Node name is null.", this);
        }
        TemplateModel result = this.getNodeProcessor(nodeName, node.getNodeNamespace(), 0);
        if (result == null) {
            String type = node.getNodeType();
            if (type == null) {
                type = "default";
            }
            result = this.getNodeProcessor("@" + type, null, 0);
        }
        return result;
    }

    private TemplateModel getNodeProcessor(String nodeName, String nsURI, int startIndex) throws TemplateException {
        int i;
        TemplateModel result = null;
        for (i = startIndex; i < this.nodeNamespaces.size(); ++i) {
            Namespace ns = null;
            try {
                ns = (Namespace)this.nodeNamespaces.get(i);
            }
            catch (ClassCastException cce) {
                throw new InvalidReferenceException("A using clause should contain a sequence of namespaces or strings that indicate the location of importable macro libraries.", this);
            }
            result = this.getNodeProcessor(ns, nodeName, nsURI);
            if (result != null) break;
        }
        if (result != null) {
            this.nodeNamespaceIndex = i + 1;
            this.currentNodeName = nodeName;
            this.currentNodeNS = nsURI;
        }
        return result;
    }

    private TemplateModel getNodeProcessor(Namespace ns, String localName, String nsURI) throws TemplateException {
        TemplateModel result = null;
        if (nsURI == null) {
            result = ns.get(localName);
            if (!(result instanceof Macro) && !(result instanceof TemplateTransformModel)) {
                result = null;
            }
        } else {
            Template template = ns.getTemplate();
            String prefix = template.getPrefixForNamespace(nsURI);
            if (prefix == null) {
                return null;
            }
            if (prefix.length() > 0) {
                result = ns.get(prefix + ":" + localName);
                if (!(result instanceof Macro) && !(result instanceof TemplateTransformModel)) {
                    result = null;
                }
            } else {
                if (nsURI.length() == 0 && !((result = ns.get("N:" + localName)) instanceof Macro) && !(result instanceof TemplateTransformModel)) {
                    result = null;
                }
                if (nsURI.equals(template.getDefaultNS()) && !((result = ns.get("D:" + localName)) instanceof Macro) && !(result instanceof TemplateTransformModel)) {
                    result = null;
                }
                if (result == null && !((result = ns.get(localName)) instanceof Macro) && !(result instanceof TemplateTransformModel)) {
                    result = null;
                }
            }
        }
        return result;
    }

    public void include(String name, String encoding, boolean parse) throws IOException, TemplateException {
        this.include(this.getTemplateForInclusion(name, encoding, parse));
    }

    public Template getTemplateForInclusion(String name, String encoding, boolean parse) throws IOException {
        if (encoding == null) {
            encoding = this.getTemplate().getEncoding();
        }
        if (encoding == null) {
            encoding = this.getConfiguration().getEncoding(this.getLocale());
        }
        return this.getConfiguration().getTemplate(name, this.getLocale(), encoding, parse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(Template includedTemplate) throws TemplateException, IOException {
        Template prevTemplate = this.getTemplate();
        this.setParent(includedTemplate);
        this.importMacros(includedTemplate);
        try {
            this.visit(includedTemplate.getRootTreeNode());
        }
        finally {
            this.setParent(prevTemplate);
        }
    }

    public Namespace importLib(String name, String namespace) throws IOException, TemplateException {
        return this.importLib(this.getTemplateForImporting(name), namespace);
    }

    public Template getTemplateForImporting(String name) throws IOException {
        return this.getTemplateForInclusion(name, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Namespace importLib(Template loadedTemplate, String namespace) throws IOException, TemplateException {
        String templateName;
        Namespace existingNamespace;
        if (this.loadedLibs == null) {
            this.loadedLibs = new HashMap();
        }
        if ((existingNamespace = (Namespace)this.loadedLibs.get(templateName = loadedTemplate.getName())) != null) {
            if (namespace != null) {
                this.setVariable(namespace, existingNamespace);
            }
        } else {
            Namespace newNamespace = new Namespace(loadedTemplate);
            if (namespace != null) {
                this.currentNamespace.put(namespace, newNamespace);
                if (this.currentNamespace == this.mainNamespace) {
                    this.globalNamespace.put(namespace, newNamespace);
                }
            }
            Namespace prevNamespace = this.currentNamespace;
            this.currentNamespace = newNamespace;
            this.loadedLibs.put(templateName, this.currentNamespace);
            Writer prevOut = this.out;
            this.out = NULL_WRITER;
            try {
                this.include(loadedTemplate);
            }
            finally {
                this.out = prevOut;
                this.currentNamespace = prevNamespace;
            }
        }
        return (Namespace)this.loadedLibs.get(templateName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String renderElementToString(TemplateElement te) throws IOException, TemplateException {
        Writer prevOut = this.out;
        try {
            StringWriter sw = new StringWriter();
            this.out = sw;
            this.visit(te);
            String string = sw.toString();
            return string;
        }
        finally {
            this.out = prevOut;
        }
    }

    void importMacros(Template template) {
        Iterator it = template.getMacros().values().iterator();
        while (it.hasNext()) {
            this.visitMacroDef((Macro)it.next());
        }
    }

    public String getNamespaceForPrefix(String prefix) {
        return this.currentNamespace.getTemplate().getNamespaceForPrefix(prefix);
    }

    public String getPrefixForNamespace(String nsURI) {
        return this.currentNamespace.getTemplate().getPrefixForNamespace(nsURI);
    }

    public String getDefaultNS() {
        return this.currentNamespace.getTemplate().getDefaultNS();
    }

    public Object __getitem__(String key) throws TemplateModelException {
        return BeansWrapper.getDefaultInstance().unwrap(this.getVariable(key));
    }

    public void __setitem__(String key, Object o) throws TemplateException {
        this.setGlobalVariable(key, this.getObjectWrapper().wrap(o));
    }

    static {
        C_NUMBER_FORMAT.setGroupingUsed(false);
        C_NUMBER_FORMAT.setDecimalSeparatorAlwaysShown(false);
        NO_OUT_ARGS = new TemplateModel[0];
        NULL_WRITER = new Writer(){

            public void write(char[] cbuf, int off, int len) {
            }

            public void flush() {
            }

            public void close() {
            }
        };
        EMPTY_BODY_WRITER = new Writer(){

            public void write(char[] cbuf, int off, int len) throws IOException {
                if (len > 0) {
                    throw new IOException("This transform does not allow nested content.");
                }
            }

            public void flush() {
            }

            public void close() {
            }
        };
    }

    private static final class DateFormatKey {
        private final int dateType;
        private final String pattern;
        private final Locale locale;
        private final TimeZone timeZone;

        DateFormatKey(int dateType, String pattern, Locale locale, TimeZone timeZone) {
            this.dateType = dateType;
            this.pattern = pattern;
            this.locale = locale;
            this.timeZone = timeZone;
        }

        public boolean equals(Object o) {
            if (o instanceof DateFormatKey) {
                DateFormatKey fk = (DateFormatKey)o;
                return this.dateType == fk.dateType && fk.pattern.equals(this.pattern) && fk.locale.equals(this.locale) && fk.timeZone.equals(this.timeZone);
            }
            return false;
        }

        public int hashCode() {
            return this.dateType ^ this.pattern.hashCode() ^ this.locale.hashCode() ^ this.timeZone.hashCode();
        }
    }

    public class Namespace
    extends SimpleHash {
        private Template template;

        Namespace() {
            this.template = Environment.this.getTemplate();
        }

        Namespace(Template template) {
            this.template = template;
        }

        public Template getTemplate() {
            return this.template == null ? Environment.this.getTemplate() : this.template;
        }
    }

    private static final class NumberFormatKey {
        private final String pattern;
        private final Locale locale;

        NumberFormatKey(String pattern, Locale locale) {
            this.pattern = pattern;
            this.locale = locale;
        }

        public boolean equals(Object o) {
            if (o instanceof NumberFormatKey) {
                NumberFormatKey fk = (NumberFormatKey)o;
                return fk.pattern.equals(this.pattern) && fk.locale.equals(this.locale);
            }
            return false;
        }

        public int hashCode() {
            return this.pattern.hashCode() ^ this.locale.hashCode();
        }
    }
}

