/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog;

import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.Action;
import org.netbeans.modules.xml.catalog.AddCatalogEntryAction;
import org.netbeans.modules.xml.catalog.CatalogEntry;
import org.netbeans.modules.xml.catalog.CatalogEntryNode;
import org.netbeans.modules.xml.catalog.RefreshAction;
import org.netbeans.modules.xml.catalog.Refreshable;
import org.netbeans.modules.xml.catalog.settings.CatalogSettings;
import org.netbeans.modules.xml.catalog.spi.CatalogDescriptor;
import org.netbeans.modules.xml.catalog.spi.CatalogDescriptor2;
import org.netbeans.modules.xml.catalog.spi.CatalogDescriptorBase;
import org.netbeans.modules.xml.catalog.spi.CatalogListener;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.netbeans.modules.xml.catalog.spi.CatalogWriter;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;

final class CatalogNode
extends BeanNode
implements Refreshable,
PropertyChangeListener,
Node.Cookie {
    private CatalogReader catalog;

    public CatalogNode(CatalogReader catalog) throws IntrospectionException {
        super((Object)catalog, (Children)new CatalogChildren(catalog));
        this.catalog = catalog;
        this.getCookieSet().add((Node.Cookie)this);
        if (catalog instanceof CatalogDescriptorBase) {
            CatalogDescriptorBase desc = (CatalogDescriptorBase)catalog;
            this.setSynchronizeName(false);
            this.setName(desc.getDisplayName());
            String bundleString = catalog instanceof CatalogWriter ? "LBL_catalogReadWrite" : "LBL_catalogReadOnly";
            this.setDisplayName(NbBundle.getMessage(CatalogNode.class, (String)bundleString, (Object)desc.getDisplayName()));
            this.setShortDescription(desc.getShortDescription());
            this.fireIconChange();
            desc.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)desc));
        }
    }

    boolean isRemovable() {
        CatalogReader reader = (CatalogReader)this.getBean();
        return CatalogSettings.getDefault().isRemovable(reader);
    }

    CatalogReader getCatalogReader() {
        return this.catalog;
    }

    public Action[] getActions(boolean context) {
        if (this.catalog instanceof CatalogWriter) {
            return new Action[]{SystemAction.get(AddCatalogEntryAction.class), SystemAction.get(RefreshAction.class), SystemAction.get(UnmountAction.class), null, SystemAction.get(PropertiesAction.class)};
        }
        return new Action[]{SystemAction.get(RefreshAction.class), SystemAction.get(UnmountAction.class), null, SystemAction.get(PropertiesAction.class)};
    }

    public Image getIcon(int type) {
        Image icon;
        String iconResource;
        if (this.catalog instanceof CatalogDescriptor2 && (iconResource = ((CatalogDescriptor2)this.catalog).getIconResource(type)) != null) {
            return ImageUtilities.loadImage((String)iconResource, (boolean)true);
        }
        if (this.catalog instanceof CatalogDescriptor && (icon = ((CatalogDescriptor)this.catalog).getIcon(type)) != null) {
            return icon;
        }
        try {
            BeanInfo catalogInfo = Introspector.getBeanInfo(this.catalog.getClass());
            Image icon2 = catalogInfo.getIcon(type);
            if (icon2 != null) {
                return icon2;
            }
        }
        catch (IntrospectionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return super.getIcon(type);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    @Override
    public void refresh() {
        this.catalog.refresh();
        ((CatalogChildren)this.getChildren()).reload();
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public void destroy() throws IOException {
        CatalogSettings mounted = CatalogSettings.getDefault();
        mounted.removeCatalog(this.catalog);
        super.destroy();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("ca-name".equals(e.getPropertyName())) {
            this.setName((String)e.getNewValue());
            this.setDisplayName((String)e.getNewValue());
        } else if ("ca-desc".equals(e.getPropertyName())) {
            this.setShortDescription((String)e.getNewValue());
        } else if ("ca-icon".equals(e.getPropertyName())) {
            this.fireIconChange();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    public static class CatalogChildren
    extends Children.Keys {
        private CatalogReader peer;
        private CatalogListener catalogListener;
        private final TreeSet keys = new TreeSet();

        public CatalogChildren(CatalogReader catalog) {
            this.peer = catalog;
        }

        public void addNotify() {
            this.catalogListener = new Lis();
            try {
                this.peer.addCatalogListener(this.catalogListener);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.reload();
        }

        public void removeNotify() {
            try {
                this.peer.removeCatalogListener(this.catalogListener);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.keys.clear();
            this.setKeys(this.keys);
        }

        public Node[] createNodes(Object key) {
            try {
                CatalogEntry catalogEntry = new CatalogEntry((String)key, this.peer);
                return new Node[]{new CatalogEntryNode(catalogEntry)};
            }
            catch (IntrospectionException ex) {
                return null;
            }
        }

        public void reload() {
            HashSet previous = new HashSet(this.keys);
            this.keys.clear();
            Iterator it = this.peer.getPublicIDs();
            if (it != null) {
                while (it.hasNext()) {
                    String publicID = (String)it.next();
                    this.keys.add(publicID);
                    if (!previous.contains(publicID)) continue;
                    this.refreshKey(publicID);
                }
            }
            this.setKeys(this.keys);
        }

        private class Lis
        implements CatalogListener {
            private Lis() {
            }

            public void notifyNew(String publicID) {
                CatalogChildren.this.keys.add(publicID);
                CatalogChildren.this.setKeys(CatalogChildren.this.keys);
            }

            public void notifyRemoved(String publicID) {
                CatalogChildren.this.keys.remove(publicID);
                CatalogChildren.this.setKeys(CatalogChildren.this.keys);
            }

            public void notifyUpdate(String publicID) {
                CatalogChildren.this.refreshKey(publicID);
            }

            public void notifyInvalidate() {
                CatalogChildren.this.reload();
            }
        }
    }

    private static final class UnmountAction
    extends NodeAction {
        private static final long serialVersionUID = 3556006276357785484L;

        public String getName() {
            return NbBundle.getMessage(CatalogNode.class, (String)"LBL_unmount");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(UnmountAction.class);
        }

        protected boolean enable(Node[] activatedNodes) {
            if (activatedNodes.length > 0) {
                for (int i = 0; i < activatedNodes.length; ++i) {
                    Node me = activatedNodes[i];
                    Node.Cookie self = me.getCookie(CatalogNode.class);
                    if (!(self instanceof CatalogNode)) continue;
                    return ((CatalogNode)self).isRemovable();
                }
            }
            return false;
        }

        protected void performAction(Node[] activatedNodes) {
            if (!this.enable(activatedNodes)) {
                return;
            }
            for (int i = 0; i < activatedNodes.length; ++i) {
                try {
                    Node me = activatedNodes[i];
                    CatalogNode self = (CatalogNode)me.getCookie(CatalogNode.class);
                    self.destroy();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        protected boolean asynchronous() {
            return false;
        }
    }
}

