/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.arrays;

import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.arrays.ArrayLikeIterator;

class MapIterator
extends ArrayLikeIterator<Object> {
    protected final ScriptObject obj;
    private final long length;

    MapIterator(ScriptObject obj, boolean includeUndefined) {
        super(includeUndefined);
        this.obj = obj;
        this.length = JSType.toUint32(obj.getLength());
        this.index = 0;
    }

    protected boolean indexInArray() {
        return (long)this.index < this.length;
    }

    @Override
    public int getLength() {
        return (int)this.length;
    }

    @Override
    public boolean hasNext() {
        if (this.length == 0L) {
            return false;
        }
        while (this.indexInArray() && !this.obj.has(this.index) && !this.includeUndefined) {
            this.bumpIndex();
        }
        return this.length != 0xFFFFFFFFL && this.indexInArray();
    }

    @Override
    public Object next() {
        return this.indexInArray() ? this.obj.get(this.bumpIndex()) : null;
    }
}

