/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.TypeDescriptor;
import jdk.nashorn.internal.codegen.objects.ObjectClassGenerator;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.FindProperty;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.SpillProperty;
import jdk.nashorn.internal.runtime.linker.Lookup;
import jdk.nashorn.internal.runtime.linker.NashornCallSiteDescriptor;
import jdk.nashorn.internal.runtime.linker.NashornGuards;
import org.dynalang.dynalink.CallSiteDescriptor;
import org.dynalang.dynalink.linker.GuardedInvocation;

class SetMethodCreator {
    private final ScriptObject sobj;
    private final PropertyMap map;
    private final FindProperty find;
    private final CallSiteDescriptor desc;

    SetMethodCreator(ScriptObject sobj, FindProperty find, CallSiteDescriptor desc) {
        this.sobj = sobj;
        this.map = sobj.getMap();
        this.find = find;
        this.desc = desc;
    }

    private String getName() {
        return this.desc.getNameToken(2);
    }

    private PropertyMap getMap() {
        return this.map;
    }

    GuardedInvocation createGuardedInvocation() {
        return this.createSetMethod().createGuardedInvocation();
    }

    private SetMethod createSetMethod() {
        if (this.find != null) {
            return this.createExistingPropertySetter();
        }
        this.checkStrictCreateNewVariable();
        if (this.sobj.isScope()) {
            return this.createGlobalPropertySetter();
        }
        return this.createNewPropertySetter();
    }

    private void checkStrictCreateNewVariable() {
        if (NashornCallSiteDescriptor.isScope(this.desc) && NashornCallSiteDescriptor.isStrict(this.desc)) {
            ECMAErrors.referenceError("not.defined", this.getName());
        }
    }

    private SetMethod createExistingPropertySetter() {
        Property property = this.find.getProperty();
        TypeDescriptor.OfField type = this.desc.getMethodType().parameterType(1);
        MethodHandle methodHandle = this.find.getSetter((Class<?>)type, NashornCallSiteDescriptor.isStrict(this.desc));
        assert (methodHandle != null);
        assert (property != null);
        MethodHandle boundHandle = !property.hasSetterFunction() && this.find.isInherited() ? ScriptObject.bindTo(methodHandle, this.find.getOwner()) : methodHandle;
        return new SetMethod(boundHandle, property);
    }

    private SetMethod createGlobalPropertySetter() {
        ScriptObject global = Context.getGlobalTrusted();
        return new SetMethod(ScriptObject.bindTo(global.addSpill(this.getName()), global), null);
    }

    private SetMethod createNewPropertySetter() {
        int nextEmbed = this.sobj.findEmbed();
        SetMethod sm = nextEmbed >= 4 ? this.createNewSpillPropertySetter() : this.createNewEmbedPropertySetter(nextEmbed);
        this.sobj.notifyPropertyAdded(this.sobj, sm.property);
        return sm;
    }

    private SetMethod createNewSpillPropertySetter() {
        int nextSpill = this.getMap().getSpillLength();
        Property property = this.createSpillProperty(nextSpill);
        return new SetMethod(this.createSpillMethodHandle(nextSpill, property), property);
    }

    private Property createSpillProperty(int nextSpill) {
        MethodHandle getter = Lookup.MH.asType(Lookup.MH.insertArguments(Lookup.MH.arrayElementGetter(Object[].class), 1, nextSpill), Lookup.GET_OBJECT_TYPE);
        MethodHandle setter = Lookup.MH.asType(Lookup.MH.insertArguments(Lookup.MH.arrayElementSetter(Object[].class), 1, nextSpill), Lookup.SET_OBJECT_TYPE);
        return new SpillProperty(this.getName(), 16, nextSpill, getter, setter);
    }

    private MethodHandle createSpillMethodHandle(int nextSpill, Property property) {
        PropertyMap oldMap = this.getMap();
        PropertyMap newMap = this.getNewMap(property);
        Object[] spill = this.sobj.spill;
        if (spill == null) {
            return Lookup.MH.insertArguments(ScriptObject.SETSPILLWITHNEW, 0, this.desc, oldMap, newMap, nextSpill);
        }
        if (nextSpill < spill.length) {
            return Lookup.MH.insertArguments(ScriptObject.SETSPILL, 0, this.desc, oldMap, newMap, nextSpill);
        }
        int newLength = (nextSpill + 8) / 8 * 8;
        return Lookup.MH.insertArguments(ScriptObject.SETSPILLWITHGROW, 0, this.desc, oldMap, newMap, nextSpill, newLength);
    }

    private SetMethod createNewEmbedPropertySetter(int nextEmbed) {
        this.sobj.useEmbed(nextEmbed);
        SpillProperty property = new SpillProperty(this.getName(), 0, nextEmbed, ScriptObject.GET_EMBED[nextEmbed], ScriptObject.SET_EMBED[nextEmbed]);
        MethodHandle methodHandle = Lookup.MH.insertArguments(ScriptObject.SETEMBED, 0, this.desc, this.getMap(), this.getNewMap(property), ((Property)property).getSetter(Object.class, this.getMap()), nextEmbed);
        return new SetMethod(methodHandle, property);
    }

    private PropertyMap getNewMap(Property property) {
        return this.getMap().addProperty(property);
    }

    private class SetMethod {
        private final MethodHandle methodHandle;
        private final Property property;

        SetMethod(MethodHandle methodHandle, Property property) {
            assert (methodHandle != null);
            this.methodHandle = methodHandle;
            this.property = property;
        }

        GuardedInvocation createGuardedInvocation() {
            return new GuardedInvocation(this.methodHandle, this.getGuard());
        }

        private MethodHandle getGuard() {
            return this.needsNoGuard() ? null : NashornGuards.getMapGuard(SetMethodCreator.this.getMap());
        }

        private boolean needsNoGuard() {
            return NashornCallSiteDescriptor.isFastScope(SetMethodCreator.this.desc) && (ObjectClassGenerator.OBJECT_FIELDS_ONLY || this.isPropertyTypeStable());
        }

        private boolean isPropertyTypeStable() {
            return this.property == null || !this.property.canChangeType();
        }
    }
}

