/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.ScriptFunctionImpl;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.arrays.ArrayData;
import jdk.nashorn.internal.runtime.linker.Lookup;

public final class NativeStrictArguments
extends ScriptObject {
    private static final MethodHandle G$LENGTH = NativeStrictArguments.findOwnMH("G$length", Object.class, Object.class);
    private static final MethodHandle S$LENGTH = NativeStrictArguments.findOwnMH("S$length", Void.TYPE, Object.class, Object.class);
    private static final PropertyMap nasgenmap$;
    private Object length;
    private final Object[] namedArgs;

    NativeStrictArguments(Object[] values, int numParams) {
        super(nasgenmap$);
        this.setIsArguments();
        ScriptFunction func = ScriptFunctionImpl.getTypeErrorThrower();
        this.setUserAccessors("caller", func, func);
        this.setUserAccessors("callee", func, func);
        this.setArray(ArrayData.allocate(values));
        this.length = values.length;
        this.namedArgs = new Object[numParams];
        if (numParams > values.length) {
            Arrays.fill(this.namedArgs, ScriptRuntime.UNDEFINED);
        }
        System.arraycopy(values, 0, this.namedArgs, 0, Math.min(this.namedArgs.length, values.length));
        this.setProto(Global.objectPrototype());
    }

    @Override
    public String getClassName() {
        return "Arguments";
    }

    @Override
    public Object getArgument(int key) {
        return key >= 0 && key < this.namedArgs.length ? this.namedArgs[key] : ScriptRuntime.UNDEFINED;
    }

    @Override
    public void setArgument(int key, Object value) {
        if (key >= 0 && key < this.namedArgs.length) {
            this.namedArgs[key] = value;
        }
    }

    public static Object G$length(Object self) {
        if (self instanceof NativeStrictArguments) {
            return ((NativeStrictArguments)self).getArgumentsLength();
        }
        return 0;
    }

    public static void S$length(Object self, Object value) {
        if (self instanceof NativeStrictArguments) {
            ((NativeStrictArguments)self).setArgumentsLength(value);
        }
    }

    private Object getArgumentsLength() {
        return this.length;
    }

    private void setArgumentsLength(Object length) {
        this.length = length;
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findStatic(MethodHandles.publicLookup(), NativeStrictArguments.class, name, Lookup.MH.type(rtype, types));
    }

    static {
        PropertyMap map = PropertyMap.newMap(NativeStrictArguments.class);
        map = Lookup.newProperty(map, "length", 2, G$LENGTH, S$LENGTH);
        map = ScriptFunctionImpl.newThrowerProperty(map, "caller", 6);
        nasgenmap$ = map = ScriptFunctionImpl.newThrowerProperty(map, "callee", 6);
    }
}

