/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.NativeArray;
import jdk.nashorn.internal.objects.NativeRegExpExecResult;
import jdk.nashorn.internal.objects.PrototypeObject;
import jdk.nashorn.internal.objects.annotations.Constructor;
import jdk.nashorn.internal.objects.annotations.Function;
import jdk.nashorn.internal.objects.annotations.Getter;
import jdk.nashorn.internal.objects.annotations.Property;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.objects.annotations.SpecializedConstructor;
import jdk.nashorn.internal.parser.RegExp;
import jdk.nashorn.internal.runtime.BitVector;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ParserException;
import jdk.nashorn.internal.runtime.PropertyAccess;
import jdk.nashorn.internal.runtime.RegExpMatch;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.linker.Lookup;

@ScriptClass(value="RegExp")
public final class NativeRegExp
extends ScriptObject {
    static final MethodHandle REGEXP_STATICS_HANDLER = NativeRegExp.findOwnMH("regExpStaticsHandler", Object.class, Object.class, Object.class);
    @Property(attributes=6)
    public Object lastIndex;
    private String input;
    private boolean global;
    private boolean ignoreCase;
    private boolean multiline;
    private Pattern pattern;
    private BitVector groupsInNegativeLookahead;
    private Object constructor;
    static final String LAST_REGEXP_MATCH = "__last_regexp_match__";

    NativeRegExp(String input, String flagString) {
        RegExp regExp = null;
        try {
            regExp = new RegExp(input, flagString);
        }
        catch (ParserException e) {
            e.throwAsEcmaException();
            throw new AssertionError();
        }
        this.setLastIndex(0);
        this.input = regExp.getInput();
        this.global = regExp.isGlobal();
        this.ignoreCase = regExp.isIgnoreCase();
        this.multiline = regExp.isMultiline();
        this.pattern = regExp.getPattern();
        this.groupsInNegativeLookahead = regExp.getGroupsInNegativeLookahead();
        this.init();
    }

    NativeRegExp(String string) {
        this(string, "");
    }

    NativeRegExp(NativeRegExp regExp) {
        this.input = regExp.getInput();
        this.global = regExp.getGlobal();
        this.multiline = regExp.getMultiline();
        this.ignoreCase = regExp.getIgnoreCase();
        this.lastIndex = regExp.getLastIndexObject();
        this.pattern = regExp.getPattern();
        this.groupsInNegativeLookahead = regExp.getGroupsInNegativeLookahead();
        this.init();
    }

    NativeRegExp(Pattern pattern) {
        this.input = pattern.pattern();
        this.multiline = (pattern.flags() & 8) != 0;
        this.ignoreCase = (pattern.flags() & 2) != 0;
        this.lastIndex = 0;
        this.pattern = pattern;
        this.init();
    }

    @Override
    public String getClassName() {
        return "RegExp";
    }

    @Constructor(arity=2)
    public static Object constructor(boolean isNew, Object self, Object ... args) {
        if (args.length > 1) {
            return NativeRegExp.newRegExp(args[0], args[1]);
        }
        if (args.length > 0) {
            return NativeRegExp.newRegExp(args[0], ScriptRuntime.UNDEFINED);
        }
        return NativeRegExp.newRegExp(ScriptRuntime.UNDEFINED, ScriptRuntime.UNDEFINED);
    }

    @SpecializedConstructor
    public static Object constructor(boolean isNew, Object self) {
        return new NativeRegExp("", "");
    }

    @SpecializedConstructor
    public static Object constructor(boolean isNew, Object self, Object pattern) {
        return NativeRegExp.newRegExp(pattern, ScriptRuntime.UNDEFINED);
    }

    @SpecializedConstructor
    public static Object constructor(boolean isNew, Object self, Object pattern, Object flags) {
        return NativeRegExp.newRegExp(pattern, flags);
    }

    public static NativeRegExp newRegExp(Object regexp, Object flags) {
        String patternString = "";
        String flagString = "";
        boolean flagsDefined = false;
        if (flags != ScriptRuntime.UNDEFINED) {
            flagsDefined = true;
            flagString = JSType.toString(flags);
        }
        if (regexp != ScriptRuntime.UNDEFINED) {
            if (regexp instanceof NativeRegExp) {
                if (!flagsDefined) {
                    return (NativeRegExp)regexp;
                }
                ECMAErrors.typeError("regex.cant.supply.flags", new String[0]);
            }
            patternString = JSType.toString(regexp);
        }
        return new NativeRegExp(patternString, flagString);
    }

    private String getFlagString() {
        StringBuilder sb = new StringBuilder();
        if (this.global) {
            sb.append('g');
        }
        if (this.ignoreCase) {
            sb.append('i');
        }
        if (this.multiline) {
            sb.append('m');
        }
        return sb.toString();
    }

    @Override
    public String safeToString() {
        return "[RegExp " + this.toString() + "]";
    }

    public String toString() {
        return "/" + this.input + "/" + this.getFlagString();
    }

    @Function(attributes=2)
    public static Object compile(Object self, Object pattern, Object flags) {
        NativeRegExp regExp = NativeRegExp.checkRegExp(self);
        NativeRegExp compiled = NativeRegExp.newRegExp(pattern, flags);
        regExp.setInput(compiled.getInput());
        regExp.setGlobal(compiled.getGlobal());
        regExp.setIgnoreCase(compiled.getIgnoreCase());
        regExp.setMultiline(compiled.getMultiline());
        regExp.setPattern(compiled.getPattern());
        regExp.setGroupsInNegativeLookahead(compiled.getGroupsInNegativeLookahead());
        return regExp;
    }

    @Function(attributes=2)
    public static Object exec(Object self, Object string) {
        return NativeRegExp.checkRegExp(self).exec(JSType.toString(string));
    }

    @Function(attributes=2)
    public static Object test(Object self, Object string) {
        return NativeRegExp.checkRegExp(self).test(JSType.toString(string));
    }

    @Function(attributes=2)
    public static Object toString(Object self) {
        return NativeRegExp.checkRegExp(self).toString();
    }

    @Getter(attributes=7)
    public static Object source(Object self) {
        return NativeRegExp.checkRegExp((Object)self).input;
    }

    @Getter(attributes=7)
    public static Object global(Object self) {
        return NativeRegExp.checkRegExp((Object)self).global;
    }

    @Getter(attributes=7)
    public static Object ignoreCase(Object self) {
        return NativeRegExp.checkRegExp((Object)self).ignoreCase;
    }

    @Getter(attributes=7)
    public static Object multiline(Object self) {
        return NativeRegExp.checkRegExp((Object)self).multiline;
    }

    private RegExpMatch execInner(String string) {
        int start;
        if (this.pattern == null) {
            return null;
        }
        Matcher matcher = this.pattern.matcher(string);
        int n = start = this.global ? this.getLastIndex() : 0;
        if (start < 0 || start > string.length()) {
            this.setLastIndex(0);
            return null;
        }
        if (!matcher.find(start)) {
            this.setLastIndex(0);
            return null;
        }
        if (this.global) {
            this.setLastIndex(matcher.end());
        }
        return new RegExpMatch(string, matcher.start(), this.groups(matcher));
    }

    private Object[] groups(Matcher matcher) {
        int groupCount = matcher.groupCount();
        Object[] groups = new Object[groupCount + 1];
        int lastGroupStart = matcher.start();
        for (int i = 0; i <= groupCount; ++i) {
            int groupStart = matcher.start(i);
            if (lastGroupStart > groupStart || this.groupsInNegativeLookahead != null && this.groupsInNegativeLookahead.isSet(i)) {
                groups[i] = ScriptRuntime.UNDEFINED;
                continue;
            }
            String group = matcher.group(i);
            groups[i] = group == null ? ScriptRuntime.UNDEFINED : group;
            lastGroupStart = groupStart;
        }
        return groups;
    }

    public Object exec(String string) {
        RegExpMatch m = this.execInner(string);
        if (m == null) {
            return this.setLastRegExpMatch(null);
        }
        return this.setLastRegExpMatch(new NativeRegExpExecResult(m));
    }

    public static Object regExpStaticsHandler(Object self, Object name) {
        String propName = JSType.toString(name);
        if (self instanceof ScriptObject) {
            ScriptObject sobj = (ScriptObject)self;
            Object value = sobj.get(LAST_REGEXP_MATCH);
            if (!(value instanceof NativeRegExpExecResult)) {
                return ScriptRuntime.UNDEFINED;
            }
            NativeRegExpExecResult lastMatch = (NativeRegExpExecResult)value;
            if (propName.length() > 0 && propName.charAt(0) == '$') {
                int index = 0;
                try {
                    index = Integer.parseInt(propName.substring(1));
                }
                catch (Exception ignored) {
                    return ScriptRuntime.UNDEFINED;
                }
                if (index < 1 && index > 9) {
                    return ScriptRuntime.UNDEFINED;
                }
                return lastMatch.get(index);
            }
            switch (propName) {
                case "input": {
                    return lastMatch.input;
                }
                case "lastMatch": {
                    return lastMatch.get(0);
                }
                case "lastParen": {
                    int len = ((Number)NativeRegExpExecResult.length(lastMatch)).intValue();
                    return len > 0 ? lastMatch.get(len - 1) : ScriptRuntime.UNDEFINED;
                }
            }
        }
        return ScriptRuntime.UNDEFINED;
    }

    private Object setLastRegExpMatch(Object match) {
        if (this.constructor instanceof ScriptObject) {
            ((ScriptObject)this.constructor).set((Object)LAST_REGEXP_MATCH, match, this.isStrictContext());
        }
        return match;
    }

    public Object test(String string) {
        return this.exec(string) != null;
    }

    Object replace(String string, String replacement, ScriptFunction function) {
        boolean found;
        Matcher matcher = this.pattern.matcher(string);
        String replace = replacement;
        if (!this.global) {
            if (!matcher.find()) {
                return string;
            }
            StringBuilder sb = new StringBuilder();
            if (function != null) {
                replace = this.callReplaceValue(function, matcher, string);
            }
            this.appendReplacement(matcher, string, replace, sb, 0);
            sb.append(string, matcher.end(), string.length());
            return sb.toString();
        }
        int end = 0;
        this.setLastIndex(0);
        try {
            found = matcher.find(end);
        }
        catch (IndexOutOfBoundsException e) {
            found = false;
        }
        if (!found) {
            return string;
        }
        int previousLastIndex = 0;
        StringBuilder sb = new StringBuilder();
        do {
            if (function != null) {
                replace = this.callReplaceValue(function, matcher, string);
            }
            this.appendReplacement(matcher, string, replace, sb, end);
            int thisIndex = end = matcher.end();
            if (thisIndex == previousLastIndex) {
                this.setLastIndex(thisIndex + 1);
                previousLastIndex = thisIndex + 1;
                continue;
            }
            previousLastIndex = thisIndex;
        } while (matcher.find());
        sb.append(string, end, string.length());
        return sb.toString();
    }

    private void appendReplacement(Matcher matcher, String text, String replacement, StringBuilder sb, int lastAppendPosition) {
        int cursor = 0;
        StringBuilder result = new StringBuilder();
        Object[] groups = null;
        while (cursor < replacement.length()) {
            char nextChar = replacement.charAt(cursor);
            if (nextChar == '$') {
                int firstDigit;
                if ((firstDigit = (nextChar = replacement.charAt(++cursor)) - 48) >= 0 && firstDigit <= 9 && firstDigit <= matcher.groupCount()) {
                    int newRefNum;
                    int secondDigit;
                    int refNum = firstDigit;
                    if (++cursor < replacement.length() && firstDigit < matcher.groupCount() && (secondDigit = replacement.charAt(cursor) - 48) >= 0 && secondDigit <= 9 && (newRefNum = firstDigit * 10 + secondDigit) <= matcher.groupCount() && newRefNum > 0) {
                        refNum = newRefNum;
                        ++cursor;
                    }
                    if (refNum > 0) {
                        if (groups == null) {
                            groups = this.groups(matcher);
                        }
                        if (groups[refNum] == ScriptRuntime.UNDEFINED) continue;
                        result.append((String)groups[refNum]);
                        continue;
                    }
                    assert (refNum == 0);
                    result.append("$0");
                    continue;
                }
                if (nextChar == '$') {
                    result.append('$');
                    ++cursor;
                    continue;
                }
                if (nextChar == '&') {
                    result.append(matcher.group());
                    ++cursor;
                    continue;
                }
                if (nextChar == '`') {
                    result.append(text.substring(0, matcher.start()));
                    ++cursor;
                    continue;
                }
                if (nextChar == '\'') {
                    result.append(text.substring(matcher.end()));
                    ++cursor;
                    continue;
                }
                result.append('$');
                continue;
            }
            result.append(nextChar);
            ++cursor;
        }
        sb.append(text, lastAppendPosition, matcher.start());
        sb.append((CharSequence)result);
    }

    private String callReplaceValue(ScriptFunction function, Matcher matcher, String string) {
        Object[] groups = this.groups(matcher);
        Object[] args = Arrays.copyOf(groups, groups.length + 2);
        args[groups.length] = matcher.start();
        args[groups.length + 1] = string;
        PropertyAccess self = function.isStrict() ? ScriptRuntime.UNDEFINED : Global.instance();
        return JSType.toString(ScriptRuntime.apply(function, self, args));
    }

    Object split(String string, long limit) {
        return NativeRegExp.split(this, string, limit);
    }

    private static Object split(NativeRegExp regexp0, String input, long limit) {
        RegExpMatch match;
        ArrayList<Object> matches = new ArrayList<Object>();
        NativeRegExp regexp = new NativeRegExp(regexp0);
        regexp.setGlobal(true);
        if (limit == 0L) {
            return new NativeArray();
        }
        int inputLength = input.length();
        int lastLength = -1;
        int lastLastIndex = 0;
        while ((match = regexp.execInner(input)) != null) {
            int lastIndex = match.getIndex() + match.length();
            if (lastIndex > lastLastIndex) {
                matches.add(input.substring(lastLastIndex, match.getIndex()));
                if (match.getGroups().length > 1 && match.getIndex() < inputLength) {
                    matches.addAll(Arrays.asList(match.getGroups()).subList(1, match.getGroups().length));
                }
                lastLength = match.length();
                lastLastIndex = lastIndex;
                if ((long)matches.size() >= limit) break;
            }
            if (regexp.getLastIndex() != match.getIndex()) continue;
            regexp.setLastIndex(match.getIndex() + 1);
        }
        if ((long)matches.size() < limit) {
            if (lastLastIndex == input.length()) {
                if (lastLength > 0 || regexp.test("") == Boolean.FALSE) {
                    matches.add("");
                }
            } else {
                matches.add(input.substring(lastLastIndex, inputLength));
            }
        }
        return new NativeArray(matches.toArray());
    }

    Object search(String string) {
        RegExpMatch m = this.execInner(string);
        if (m == null) {
            this.setLastRegExpMatch(null);
            return -1;
        }
        this.setLastRegExpMatch(new NativeRegExpExecResult(m));
        return m.getIndex();
    }

    public int getLastIndex() {
        return JSType.toInt32(this.lastIndex);
    }

    public Object getLastIndexObject() {
        return this.lastIndex;
    }

    public void setLastIndex(int lastIndex) {
        this.lastIndex = JSType.toObject(lastIndex);
    }

    private void init() {
        ScriptObject proto = Global.instance().getRegExpPrototype();
        this.setProto(proto);
        this.constructor = PrototypeObject.getConstructor(proto);
    }

    private static NativeRegExp checkRegExp(Object self) {
        Global.checkObjectCoercible(self);
        if (self instanceof NativeRegExp) {
            return (NativeRegExp)self;
        }
        if (self != null && self == Global.instance().getRegExpPrototype()) {
            return Global.instance().DEFAULT_REGEXP;
        }
        ECMAErrors.typeError("not.a.regexp", ScriptRuntime.safeToString(self));
        return null;
    }

    private String getInput() {
        return this.input;
    }

    private void setInput(String input) {
        this.input = input;
    }

    boolean getGlobal() {
        return this.global;
    }

    private void setGlobal(boolean global) {
        this.global = global;
    }

    private boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    private void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    private boolean getMultiline() {
        return this.multiline;
    }

    private void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    private Pattern getPattern() {
        return this.pattern;
    }

    private void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    private BitVector getGroupsInNegativeLookahead() {
        return this.groupsInNegativeLookahead;
    }

    private void setGroupsInNegativeLookahead(BitVector groupsInNegativeLookahead) {
        this.groupsInNegativeLookahead = groupsInNegativeLookahead;
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findStatic(MethodHandles.publicLookup(), NativeRegExp.class, name, Lookup.MH.type(rtype, types));
    }
}

