/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.objects;

import jdk.nashorn.internal.objects.Global;
import jdk.nashorn.internal.objects.NativeArray;
import jdk.nashorn.internal.objects.annotations.Constructor;
import jdk.nashorn.internal.objects.annotations.Function;
import jdk.nashorn.internal.objects.annotations.ScriptClass;
import jdk.nashorn.internal.objects.annotations.Where;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.linker.InvokeByName;

@ScriptClass(value="Object")
public final class NativeObject {
    private static final InvokeByName TO_STRING = new InvokeByName("toString", ScriptObject.class);

    private NativeObject() {
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object getPrototypeOf(Object self, Object obj) {
        Global.checkObject(obj);
        return ((ScriptObject)obj).getProto();
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object getOwnPropertyDescriptor(Object self, Object obj, Object prop) {
        Global.checkObject(obj);
        String key = JSType.toString(prop);
        ScriptObject sobj = (ScriptObject)obj;
        return sobj.getOwnPropertyDescriptor(key);
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object getOwnPropertyNames(Object self, Object obj) {
        Global.checkObject(obj);
        return new NativeArray(((ScriptObject)obj).getOwnKeys(true));
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object create(Object self, Object proto, Object props) {
        if (proto != null) {
            Global.checkObject(proto);
        }
        ScriptObject newObj = Global.newEmptyInstance();
        newObj.setProtoCheck(proto);
        if (props != ScriptRuntime.UNDEFINED) {
            NativeObject.defineProperties(self, newObj, props);
        }
        return newObj;
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object defineProperty(Object self, Object obj, Object prop, Object attr) {
        Global.checkObject(obj);
        ((ScriptObject)obj).defineOwnProperty(JSType.toString(prop), attr, true);
        return obj;
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object defineProperties(Object self, Object obj, Object props) {
        Global.checkObject(obj);
        ScriptObject sobj = (ScriptObject)obj;
        Object propsObj = Global.toObject(props);
        if (propsObj instanceof ScriptObject) {
            String[] keys;
            for (String key : keys = ((ScriptObject)propsObj).getOwnKeys(false)) {
                String prop = JSType.toString(key);
                sobj.defineOwnProperty(prop, ((ScriptObject)propsObj).get(prop), true);
            }
        }
        return sobj;
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object seal(Object self, Object obj) {
        Global.checkObject(obj);
        return ((ScriptObject)obj).seal();
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object freeze(Object self, Object obj) {
        Global.checkObject(obj);
        return ((ScriptObject)obj).freeze();
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object preventExtensions(Object self, Object obj) {
        Global.checkObject(obj);
        return ((ScriptObject)obj).preventExtensions();
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object isSealed(Object self, Object obj) {
        Global.checkObject(obj);
        return ((ScriptObject)obj).isSealed();
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object isFrozen(Object self, Object obj) {
        Global.checkObject(obj);
        return ((ScriptObject)obj).isFrozen();
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object isExtensible(Object self, Object obj) {
        Global.checkObject(obj);
        return ((ScriptObject)obj).isExtensible();
    }

    @Function(attributes=2, where=Where.CONSTRUCTOR)
    public static Object keys(Object self, Object obj) {
        Global.checkObject(obj);
        ScriptObject sobj = (ScriptObject)obj;
        return new NativeArray(sobj.getOwnKeys(false));
    }

    @Constructor
    public static Object construct(boolean newObj, Object self, Object value) {
        JSType type = JSType.of(value);
        if (newObj || type == JSType.NULL || type == JSType.UNDEFINED) {
            switch (type) {
                case BOOLEAN: 
                case NUMBER: 
                case STRING: {
                    return Global.toObject(value);
                }
                case OBJECT: 
                case FUNCTION: {
                    return value;
                }
            }
            return Global.newEmptyInstance();
        }
        return Global.toObject(value);
    }

    @Function(attributes=2)
    public static Object toString(Object self) {
        return ScriptRuntime.builtinObjectToString(self);
    }

    @Function(attributes=2)
    public static Object toLocaleString(Object self) {
        Object obj = JSType.toScriptObject(self);
        if (obj instanceof ScriptObject) {
            ScriptObject sobj = (ScriptObject)self;
            try {
                Object toString = TO_STRING.getGetter().invokeExact(sobj);
                if (toString instanceof ScriptFunction) {
                    return TO_STRING.getInvoker().invokeExact(toString, sobj);
                }
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            ECMAErrors.typeError("not.a.function", "toString");
            throw new AssertionError();
        }
        return ScriptRuntime.builtinObjectToString(self);
    }

    @Function(attributes=2)
    public static Object valueOf(Object self) {
        return Global.toObject(self);
    }

    @Function(attributes=2)
    public static Object hasOwnProperty(Object self, Object v) {
        String str = JSType.toString(v);
        Object obj = Global.toObject(self);
        return obj instanceof ScriptObject && ((ScriptObject)obj).hasOwnProperty(str);
    }

    @Function(attributes=2)
    public static Object isPrototypeOf(Object self, Object v) {
        if (!(v instanceof ScriptObject)) {
            return false;
        }
        Object obj = Global.toObject(self);
        ScriptObject proto = (ScriptObject)v;
        do {
            if ((proto = proto.getProto()) != obj) continue;
            return true;
        } while (proto != null);
        return false;
    }

    @Function(attributes=2)
    public static Object propertyIsEnumerable(Object self, Object v) {
        String str = JSType.toString(v);
        Object obj = Global.toObject(self);
        if (obj instanceof ScriptObject) {
            Property property = ((ScriptObject)obj).getMap().findProperty(str);
            return property != null && property.isEnumerable();
        }
        return false;
    }
}

