/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;

public class WithNode
extends Node {
    private Node expression;
    private Block body;

    public WithNode(Source source, long token, int finish, Node expression, Block body) {
        super(source, token, finish);
        this.expression = expression;
        this.body = body;
    }

    private WithNode(WithNode withNode, Node.CopyState cs) {
        super(withNode);
        this.expression = cs.existingOrCopy(withNode.expression);
        this.body = (Block)cs.existingOrCopy(withNode.body);
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new WithNode(this, cs);
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            this.expression = this.expression.accept(visitor);
            this.body = (Block)this.body.accept(visitor);
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("with (");
        this.expression.toString(sb);
        sb.append(')');
    }

    public Block getBody() {
        return this.body;
    }

    public void setBody(Block body) {
        this.body = body;
    }

    public Node getExpression() {
        return this.expression;
    }

    public void setExpression(Node expression) {
        this.expression = expression;
    }
}

