/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.Assignment;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.Source;

public class UnaryNode
extends Node
implements Assignment<Node> {
    protected Node rhs;

    public UnaryNode(Source source, long token, Node rhs) {
        super(source, token, Token.descPosition(token));
        this.start = Math.min(rhs.getStart(), Token.descPosition(token));
        this.finish = Math.max(Token.descPosition(token) + Token.descLength(token), rhs.getFinish());
        this.rhs = rhs;
    }

    protected UnaryNode(UnaryNode unaryNode, Node.CopyState cs) {
        super(unaryNode);
        this.rhs = cs.existingOrCopy(unaryNode.rhs);
    }

    @Override
    public boolean isAssignment() {
        switch (this.tokenType()) {
            case DECPOSTFIX: 
            case DECPREFIX: 
            case INCPOSTFIX: 
            case INCPREFIX: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSelfModifying() {
        return this.isAssignment();
    }

    @Override
    public Type getWidestOperationType() {
        return this.isAssignment() ? Type.NUMBER : Type.OBJECT;
    }

    @Override
    public Node getAssignmentDest() {
        return this.isAssignment() ? this.rhs() : null;
    }

    @Override
    public Node getAssignmentSource() {
        return this.getAssignmentDest();
    }

    @Override
    public void setAssignmentSource(Node source) {
        this.setAssignmentDest(source);
    }

    @Override
    public void setAssignmentDest(Node source) {
        this.setRHS(source);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        return this.rhs.equals(((UnaryNode)other).rhs());
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.rhs().hashCode();
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new UnaryNode(this, cs);
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            this.rhs = this.rhs.accept(visitor);
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        TokenType type = this.tokenType();
        String name = type.getName();
        boolean isPostfix = type == TokenType.DECPOSTFIX || type == TokenType.INCPOSTFIX;
        boolean isConvert = type == TokenType.CONVERT && this.getSymbol() != null;
        boolean rhsParen = type.needsParens(this.rhs().tokenType(), false);
        int convertPos = 0;
        if (isConvert) {
            convertPos = sb.length();
            sb.append("((");
            sb.append(this.getType());
            sb.append(")");
        }
        if (!isPostfix && !isConvert) {
            if (name == null) {
                sb.append(type.name());
                rhsParen = true;
            } else {
                sb.append(name);
                if (type.ordinal() > TokenType.BIT_NOT.ordinal()) {
                    sb.append(' ');
                }
            }
        }
        if (rhsParen) {
            sb.append('(');
        }
        this.rhs().toString(sb);
        if (rhsParen) {
            sb.append(')');
        }
        if (isPostfix) {
            sb.append(type == TokenType.DECPOSTFIX ? "--" : "++");
        }
        if (isConvert) {
            boolean endsWithParenthesis;
            boolean bl = endsWithParenthesis = sb.charAt(sb.length() - 1) == ')';
            if (!endsWithParenthesis) {
                sb.append(')');
            } else {
                sb.setCharAt(convertPos, ' ');
            }
        }
    }

    public Node rhs() {
        return this.rhs;
    }

    public void setRHS(Node rhs) {
        this.rhs = rhs;
    }
}

