/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;

public class IfNode
extends Node {
    private Node test;
    private Block pass;
    private Block fail;

    public IfNode(Source source, long token, int finish, Node test, Block pass, Block fail) {
        super(source, token, finish);
        this.test = test;
        this.pass = pass;
        this.fail = fail;
    }

    private IfNode(IfNode ifNode, Node.CopyState cs) {
        super(ifNode);
        this.test = cs.existingOrCopy(ifNode.test);
        this.pass = (Block)cs.existingOrCopy(ifNode.pass);
        this.fail = (Block)cs.existingOrCopy(ifNode.fail);
    }

    @Override
    protected Node copy(Node.CopyState cs) {
        return new IfNode(this, cs);
    }

    @Override
    public Node accept(NodeVisitor visitor) {
        if (visitor.enter(this) != null) {
            this.test = this.test.accept(visitor);
            this.pass = (Block)this.pass.accept(visitor);
            if (this.fail != null) {
                this.fail = (Block)this.fail.accept(visitor);
            }
            return visitor.leave(this);
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("if (");
        this.test.toString(sb);
        sb.append(')');
    }

    public Block getFail() {
        return this.fail;
    }

    public Block getPass() {
        return this.pass;
    }

    public Node getTest() {
        return this.test;
    }

    public void setTest(Node test) {
        this.test = test;
    }
}

