/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.nashorn.internal.ir.Symbol;

public final class Frame {
    private Frame previous;
    private final ArrayList<Symbol> symbols;
    private int baseCount;
    private int count;

    public Frame(Frame previous) {
        this.previous = previous;
        this.symbols = new ArrayList();
        this.baseCount = this.getBaseCount();
        this.count = 0;
    }

    private Frame(Frame frame, List<Symbol> symbols) {
        this.previous = frame.getPrevious() == null ? null : new Frame(frame.getPrevious(), frame.getPrevious().getSymbols());
        this.symbols = new ArrayList<Symbol>(frame.getSymbols());
        this.baseCount = frame.getBaseCount();
        this.count = frame.getCount();
    }

    public Frame copy() {
        return new Frame(this, this.getSymbols());
    }

    public void addSymbol(Symbol symbol) {
        int slot = symbol.getSlot();
        if (slot < 0) {
            this.symbols.add(symbol);
            this.count += symbol.slotCount();
        }
    }

    public int realign() {
        this.baseCount = this.getBaseCount();
        this.count = 0;
        for (Symbol symbol : this.symbols) {
            if (!symbol.hasSlot()) continue;
            symbol.setSlot(this.baseCount + this.count);
            this.count += symbol.slotCount();
        }
        return this.count;
    }

    private int getBaseCount() {
        return this.previous != null ? this.previous.getSlotCount() : 0;
    }

    public int getSlotCount() {
        return this.baseCount + this.count;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Frame f = this;
        boolean hasPrev = false;
        int pos = 0;
        do {
            if (hasPrev) {
                sb.append("\n");
            }
            sb.append("#").append(pos++).append(" {baseCount:").append(this.baseCount).append(", ").append("count:").append(this.count).append("} ");
            for (Symbol var : f.getSymbols()) {
                sb.append('[').append(var.toString()).append(' ').append(var.hashCode()).append("] ");
            }
            f = f.getPrevious();
            hasPrev = true;
        } while (f != null);
        return sb.toString();
    }

    public int getCount() {
        return this.count;
    }

    public Frame getPrevious() {
        return this.previous;
    }

    public void setPrevious(Frame previous) {
        this.previous = previous;
    }

    public List<Symbol> getSymbols() {
        return Collections.unmodifiableList(this.symbols);
    }
}

