/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml.elements;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLConstants;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.elements.AbstractTagHandler;
import junit.framework.Assert;
import org.w3c.dom.Element;

public class AssertEqualsTagHandler
extends AbstractTagHandler
implements XMLConstants {
    public AssertEqualsTagHandler(Element element, IXMLTestCase iXMLTestCase) {
        super(element, iXMLTestCase);
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkElementTagName("assertequals");
        this.checkAtLeastOneRequiredAttribute(this.getElement(), new String[]{"expectedobj", "expectedrefid"});
        this.checkAtLeastOneRequiredAttribute(this.getElement(), new String[]{"actualobj", "actualrefid"});
    }

    public void processElement() throws Exception {
        this.validateElement();
        Assert.assertEquals((String)this.getMessage(), (Object)this.getExpectedObject(), (Object)this.getActualObject());
    }

    protected String getMessage() {
        return this.getString("message");
    }

    private String getExpectedRefId() {
        return this.getString("expectedrefid");
    }

    private String getActualRefId() {
        return this.getString("actualrefid");
    }

    private Object getExpectedObject() {
        if (this.getExpectedRefId() != null && this.getTestCase().getFoundObject(this.getExpectedRefId()) != null) {
            return this.getTestCase().getFoundObject(this.getExpectedRefId());
        }
        return this.getString("expectedobj");
    }

    private Object getActualObject() {
        if (this.getActualRefId() != null && this.getTestCase().getFoundObject(this.getActualRefId()) != null) {
            return this.getTestCase().getFoundObject(this.getActualRefId());
        }
        return this.getString("actualobj");
    }
}

