/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.extensions.xml.XMLConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLUtil
implements XMLConstants {
    private XMLUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document parse(InputStream inputStream) throws Exception {
        Document document;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            try {
                document = documentBuilderFactory.newDocumentBuilder().parse(inputStream);
                Object var6_4 = null;
                if (inputStream == null) return document;
            }
            catch (SAXException sAXException) {
                Exception exception = sAXException;
                if (sAXException.getException() != null) {
                    exception = sAXException.getException();
                }
                exception.printStackTrace();
                throw exception;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
                throw parserConfigurationException;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return document;
    }

    public static String getPath(Node node) {
        StringBuffer stringBuffer = new StringBuffer(500);
        if (node.getParentNode() != null && node.getParentNode() instanceof Element) {
            stringBuffer.append(XMLUtil.getPath(node.getParentNode()));
            stringBuffer.append(".");
        }
        stringBuffer.append(XMLUtil.getName(node));
        return stringBuffer.toString();
    }

    public static String getName(Node node) {
        String string = null;
        if (node instanceof Element) {
            string = XMLUtil.getAttribute((Element)node, "name");
        }
        return string == null ? node.getNodeName() : string;
    }

    public static String getAttribute(Element element, String string) {
        String string2 = element.getAttribute(string);
        return string2 != null && string2.trim().length() == 0 ? null : string2;
    }

    public static boolean getBooleanAttributeValue(Element element, String string) {
        String string2 = element.getAttribute(string);
        return new Boolean(string2);
    }

    public static InputStream readFileFromClasspath(String string) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
    }

    public static InputStream readFileFromClassContext(Class clazz, String string) {
        return clazz.getResourceAsStream(string);
    }
}

