/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.xml;

import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.xml.JFCXMLConstants;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.elements.AbstractTagHandler;
import org.w3c.dom.Element;

public class AWTThreadTagHandler
extends AbstractTagHandler
implements JFCXMLConstants {
    public AWTThreadTagHandler(Element element, IXMLTestCase iXMLTestCase) {
        super(element, iXMLTestCase);
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkElementTagName("awtthread");
        this.checkRequiredAttribute("action");
        if ("sleep".equals(this.getString("action"))) {
            this.checkRequiredAttribute("duration");
        }
    }

    public void processElement() throws Exception {
        this.validateElement();
        Element element = this.getElement();
        String string = this.getString("action");
        if ("flush".equals(string)) {
            ((JFCTestCase)((Object)this.getTestCase())).flushAWT();
        } else if ("pause".equals(string)) {
            ((JFCTestCase)((Object)this.getTestCase())).pauseAWT();
        } else if ("resume".equals(string)) {
            ((JFCTestCase)((Object)this.getTestCase())).resumeAWT();
        } else if ("sleep".equals(string)) {
            ((JFCTestCase)((Object)this.getTestCase())).sleep(this.getSleepTime());
        }
    }

    protected long getSleepTime() {
        return this.getLong("sleeptime", 300L);
    }
}

